/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="List Locks by path")
public class LockEntity {
    @JsonProperty(value="path")
    private String path = null;
    @JsonProperty(value="timeout")
    private Integer timeout = null;
    @JsonProperty(value="depth")
    private String depth = null;
    @JsonProperty(value="recursive")
    private Boolean recursive = null;
    @JsonProperty(value="owner")
    private String owner = null;
    @JsonProperty(value="scope")
    private String scope = null;
    @JsonProperty(value="exclusive")
    private Boolean exclusive = null;
    @JsonProperty(value="token")
    private String token = null;
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="allow_access_by_any_user")
    private Boolean allowAccessByAnyUser = null;
    @JsonProperty(value="user_id")
    private Integer userId = null;
    @JsonProperty(value="username")
    private String username = null;

    public LockEntity path(String path) {
        this.path = path;
        return this;
    }

    @Schema(example="locked_file", description="Path")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public LockEntity timeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    @Schema(example="43200", description="Lock timeout in seconds")
    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public LockEntity depth(String depth) {
        this.depth = depth;
        return this;
    }

    @Schema(example="infinity", description="DEPRECATED: Lock depth")
    public String getDepth() {
        return this.depth;
    }

    public void setDepth(String depth) {
        this.depth = depth;
    }

    public LockEntity recursive(Boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    @Schema(example="true", description="Does lock apply to subfolders?")
    public Boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(Boolean recursive) {
        this.recursive = recursive;
    }

    public LockEntity owner(String owner) {
        this.owner = owner;
        return this;
    }

    @Schema(example="user", description="Owner of the lock.  This can be any arbitrary string.")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public LockEntity scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Schema(example="shared", description="DEPRECATED: Lock scope")
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public LockEntity exclusive(Boolean exclusive) {
        this.exclusive = exclusive;
        return this;
    }

    @Schema(description="Is lock exclusive?")
    public Boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(Boolean exclusive) {
        this.exclusive = exclusive;
    }

    public LockEntity token(String token) {
        this.token = token;
        return this;
    }

    @Schema(example="17c54824e9931a4688ca032d03f6663c", description="Lock token.  Use to release lock.")
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public LockEntity type(String type) {
        this.type = type;
        return this;
    }

    @Schema(example="write", description="DEPRECATED: Lock type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public LockEntity allowAccessByAnyUser(Boolean allowAccessByAnyUser) {
        this.allowAccessByAnyUser = allowAccessByAnyUser;
        return this;
    }

    @Schema(description="Can lock be modified by users other than its creator?")
    public Boolean isAllowAccessByAnyUser() {
        return this.allowAccessByAnyUser;
    }

    public void setAllowAccessByAnyUser(Boolean allowAccessByAnyUser) {
        this.allowAccessByAnyUser = allowAccessByAnyUser;
    }

    public LockEntity userId(Integer userId) {
        this.userId = userId;
        return this;
    }

    @Schema(example="1", description="Lock creator user ID")
    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public LockEntity username(String username) {
        this.username = username;
        return this;
    }

    @Schema(example="username", description="Lock creator username")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockEntity lockEntity = (LockEntity)o;
        return Objects.equals(this.path, lockEntity.path) && Objects.equals(this.timeout, lockEntity.timeout) && Objects.equals(this.depth, lockEntity.depth) && Objects.equals(this.recursive, lockEntity.recursive) && Objects.equals(this.owner, lockEntity.owner) && Objects.equals(this.scope, lockEntity.scope) && Objects.equals(this.exclusive, lockEntity.exclusive) && Objects.equals(this.token, lockEntity.token) && Objects.equals(this.type, lockEntity.type) && Objects.equals(this.allowAccessByAnyUser, lockEntity.allowAccessByAnyUser) && Objects.equals(this.userId, lockEntity.userId) && Objects.equals(this.username, lockEntity.username);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.timeout, this.depth, this.recursive, this.owner, this.scope, this.exclusive, this.token, this.type, this.allowAccessByAnyUser, this.userId, this.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LockEntity {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    depth: ").append(this.toIndentedString(this.depth)).append("\n");
        sb.append("    recursive: ").append(this.toIndentedString(this.recursive)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    exclusive: ").append(this.toIndentedString(this.exclusive)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    allowAccessByAnyUser: ").append(this.toIndentedString(this.allowAccessByAnyUser)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

