/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="List IP Addresses associated with the current site")
public class IpAddressEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="associated_with")
    private String associatedWith = null;
    @JsonProperty(value="group_id")
    private Integer groupId = null;
    @JsonProperty(value="ip_addresses")
    private List<String> ipAddresses = null;

    public IpAddressEntity id(String id) {
        this.id = id;
        return this;
    }

    @Schema(example="Site", description="Unique label for list; used by Zapier and other integrations.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public IpAddressEntity associatedWith(String associatedWith) {
        this.associatedWith = associatedWith;
        return this;
    }

    @Schema(example="Site", description="The object that this public IP address list is associated with.")
    public String getAssociatedWith() {
        return this.associatedWith;
    }

    public void setAssociatedWith(String associatedWith) {
        this.associatedWith = associatedWith;
    }

    public IpAddressEntity groupId(Integer groupId) {
        this.groupId = groupId;
        return this;
    }

    @Schema(example="1", description="Group ID")
    public Integer getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Integer groupId) {
        this.groupId = groupId;
    }

    public IpAddressEntity ipAddresses(List<String> ipAddresses) {
        this.ipAddresses = ipAddresses;
        return this;
    }

    public IpAddressEntity addIpAddressesItem(String ipAddressesItem) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        this.ipAddresses.add(ipAddressesItem);
        return this;
    }

    @Schema(example="[\"127.0.0.1\"]", description="A list of IP addresses.")
    public List<String> getIpAddresses() {
        return this.ipAddresses;
    }

    public void setIpAddresses(List<String> ipAddresses) {
        this.ipAddresses = ipAddresses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IpAddressEntity ipAddressEntity = (IpAddressEntity)o;
        return Objects.equals(this.id, ipAddressEntity.id) && Objects.equals(this.associatedWith, ipAddressEntity.associatedWith) && Objects.equals(this.groupId, ipAddressEntity.groupId) && Objects.equals(this.ipAddresses, ipAddressEntity.ipAddresses);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.associatedWith, this.groupId, this.ipAddresses);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IpAddressEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    associatedWith: ").append(this.toIndentedString(this.associatedWith)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("    ipAddresses: ").append(this.toIndentedString(this.ipAddresses)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

