/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

public class InvoiceLineItemEntity {
    @JsonProperty(value="amount")
    private Double amount = null;
    @JsonProperty(value="created_at")
    private DateTime createdAt = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="service_end_at")
    private DateTime serviceEndAt = null;
    @JsonProperty(value="service_start_at")
    private DateTime serviceStartAt = null;
    @JsonProperty(value="updated_at")
    private DateTime updatedAt = null;
    @JsonProperty(value="plan")
    private String plan = null;
    @JsonProperty(value="site")
    private String site = null;

    public InvoiceLineItemEntity amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @Schema(example="1", description="Invoice line item amount")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public InvoiceLineItemEntity createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(description="Invoice line item created at date/time")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public InvoiceLineItemEntity description(String description) {
        this.description = description;
        return this;
    }

    @Schema(example="Service from 2019-01-01 through 2019-12-31", description="Invoice line item description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public InvoiceLineItemEntity type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(example="invoice", description="Invoice line item type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public InvoiceLineItemEntity serviceEndAt(DateTime serviceEndAt) {
        this.serviceEndAt = serviceEndAt;
        return this;
    }

    @Schema(description="Invoice line item service end date/time")
    public DateTime getServiceEndAt() {
        return this.serviceEndAt;
    }

    public void setServiceEndAt(DateTime serviceEndAt) {
        this.serviceEndAt = serviceEndAt;
    }

    public InvoiceLineItemEntity serviceStartAt(DateTime serviceStartAt) {
        this.serviceStartAt = serviceStartAt;
        return this;
    }

    @Schema(description="Invoice line item service start date/time")
    public DateTime getServiceStartAt() {
        return this.serviceStartAt;
    }

    public void setServiceStartAt(DateTime serviceStartAt) {
        this.serviceStartAt = serviceStartAt;
    }

    public InvoiceLineItemEntity updatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Schema(description="Invoice line item updated date/time")
    public DateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public InvoiceLineItemEntity plan(String plan) {
        this.plan = plan;
        return this;
    }

    @Schema(example="Enterprise", description="Plan name")
    public String getPlan() {
        return this.plan;
    }

    public void setPlan(String plan) {
        this.plan = plan;
    }

    public InvoiceLineItemEntity site(String site) {
        this.site = site;
        return this;
    }

    @Schema(example="My site", description="Site name")
    public String getSite() {
        return this.site;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvoiceLineItemEntity invoiceLineItemEntity = (InvoiceLineItemEntity)o;
        return Objects.equals(this.amount, invoiceLineItemEntity.amount) && Objects.equals(this.createdAt, invoiceLineItemEntity.createdAt) && Objects.equals(this.description, invoiceLineItemEntity.description) && Objects.equals((Object)this.type, (Object)invoiceLineItemEntity.type) && Objects.equals(this.serviceEndAt, invoiceLineItemEntity.serviceEndAt) && Objects.equals(this.serviceStartAt, invoiceLineItemEntity.serviceStartAt) && Objects.equals(this.updatedAt, invoiceLineItemEntity.updatedAt) && Objects.equals(this.plan, invoiceLineItemEntity.plan) && Objects.equals(this.site, invoiceLineItemEntity.site);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.createdAt, this.description, this.type, this.serviceEndAt, this.serviceStartAt, this.updatedAt, this.plan, this.site});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InvoiceLineItemEntity {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    serviceEndAt: ").append(this.toIndentedString(this.serviceEndAt)).append("\n");
        sb.append("    serviceStartAt: ").append(this.toIndentedString(this.serviceStartAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    plan: ").append(this.toIndentedString(this.plan)).append("\n");
        sb.append("    site: ").append(this.toIndentedString(this.site)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        INVOICE("invoice"),
        ADJUSTMENT("adjustment"),
        USAGE_OVERAGE("usage_overage"),
        USER_OVERAGE("user_overage"),
        ADDON_SUBSCRIPTION("addon_subscription"),
        MISC_FEE("misc_fee");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

