/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="List Inbox Registrations")
public class InboxRegistrationEntity {
    @JsonProperty(value="code")
    private String code = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="company")
    private String company = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="clickwrap_body")
    private String clickwrapBody = null;
    @JsonProperty(value="form_field_set_id")
    private Integer formFieldSetId = null;
    @JsonProperty(value="form_field_data")
    private String formFieldData = null;

    public InboxRegistrationEntity code(String code) {
        this.code = code;
        return this;
    }

    @Schema(example="abc123", description="Registration cookie code")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public InboxRegistrationEntity name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="account", description="Registrant name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InboxRegistrationEntity company(String company) {
        this.company = company;
        return this;
    }

    @Schema(example="Action Verb", description="Registrant company name")
    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public InboxRegistrationEntity email(String email) {
        this.email = email;
        return this;
    }

    @Schema(example="john.doe@files.com", description="Registrant email address")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public InboxRegistrationEntity clickwrapBody(String clickwrapBody) {
        this.clickwrapBody = clickwrapBody;
        return this;
    }

    @Schema(description="Clickwrap text that was shown to the registrant")
    public String getClickwrapBody() {
        return this.clickwrapBody;
    }

    public void setClickwrapBody(String clickwrapBody) {
        this.clickwrapBody = clickwrapBody;
    }

    public InboxRegistrationEntity formFieldSetId(Integer formFieldSetId) {
        this.formFieldSetId = formFieldSetId;
        return this;
    }

    @Schema(example="1", description="Id of associated form field set")
    public Integer getFormFieldSetId() {
        return this.formFieldSetId;
    }

    public void setFormFieldSetId(Integer formFieldSetId) {
        this.formFieldSetId = formFieldSetId;
    }

    public InboxRegistrationEntity formFieldData(String formFieldData) {
        this.formFieldData = formFieldData;
        return this;
    }

    @Schema(description="Data for form field set with form field ids as keys and user data as values")
    public String getFormFieldData() {
        return this.formFieldData;
    }

    public void setFormFieldData(String formFieldData) {
        this.formFieldData = formFieldData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboxRegistrationEntity inboxRegistrationEntity = (InboxRegistrationEntity)o;
        return Objects.equals(this.code, inboxRegistrationEntity.code) && Objects.equals(this.name, inboxRegistrationEntity.name) && Objects.equals(this.company, inboxRegistrationEntity.company) && Objects.equals(this.email, inboxRegistrationEntity.email) && Objects.equals(this.clickwrapBody, inboxRegistrationEntity.clickwrapBody) && Objects.equals(this.formFieldSetId, inboxRegistrationEntity.formFieldSetId) && Objects.equals(this.formFieldData, inboxRegistrationEntity.formFieldData);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.name, this.company, this.email, this.clickwrapBody, this.formFieldSetId, this.formFieldData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InboxRegistrationEntity {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    company: ").append(this.toIndentedString(this.company)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    clickwrapBody: ").append(this.toIndentedString(this.clickwrapBody)).append("\n");
        sb.append("    formFieldSetId: ").append(this.toIndentedString(this.formFieldSetId)).append("\n");
        sb.append("    formFieldData: ").append(this.toIndentedString(this.formFieldData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

