/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="List Inbox Recipients")
public class InboxRecipientEntity {
    @JsonProperty(value="company")
    private String company = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="note")
    private String note = null;
    @JsonProperty(value="recipient")
    private String recipient = null;
    @JsonProperty(value="sent_at")
    private DateTime sentAt = null;

    public InboxRecipientEntity company(String company) {
        this.company = company;
        return this;
    }

    @Schema(example="Acme Inc.", description="The recipient's company.")
    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public InboxRecipientEntity name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="John Doe", description="The recipient's name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InboxRecipientEntity note(String note) {
        this.note = note;
        return this;
    }

    @Schema(example="Some note.", description="A note sent to the recipient with the inbox.")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public InboxRecipientEntity recipient(String recipient) {
        this.recipient = recipient;
        return this;
    }

    @Schema(example="john.doe@example.com", description="The recipient's email address.")
    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public InboxRecipientEntity sentAt(DateTime sentAt) {
        this.sentAt = sentAt;
        return this;
    }

    @Schema(description="When the Inbox was shared with this recipient.")
    public DateTime getSentAt() {
        return this.sentAt;
    }

    public void setSentAt(DateTime sentAt) {
        this.sentAt = sentAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboxRecipientEntity inboxRecipientEntity = (InboxRecipientEntity)o;
        return Objects.equals(this.company, inboxRecipientEntity.company) && Objects.equals(this.name, inboxRecipientEntity.name) && Objects.equals(this.note, inboxRecipientEntity.note) && Objects.equals(this.recipient, inboxRecipientEntity.recipient) && Objects.equals(this.sentAt, inboxRecipientEntity.sentAt);
    }

    public int hashCode() {
        return Objects.hash(this.company, this.name, this.note, this.recipient, this.sentAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InboxRecipientEntity {\n");
        sb.append("    company: ").append(this.toIndentedString(this.company)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    recipient: ").append(this.toIndentedString(this.recipient)).append("\n");
        sb.append("    sentAt: ").append(this.toIndentedString(this.sentAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

