/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

public class HistoryExportsBody {
    @JsonProperty(value="user_id")
    private Integer userId = null;
    @JsonProperty(value="start_at")
    private DateTime startAt = null;
    @JsonProperty(value="end_at")
    private DateTime endAt = null;
    @JsonProperty(value="query_action")
    private String queryAction = null;
    @JsonProperty(value="query_interface")
    private String queryInterface = null;
    @JsonProperty(value="query_user_id")
    private String queryUserId = null;
    @JsonProperty(value="query_file_id")
    private String queryFileId = null;
    @JsonProperty(value="query_parent_id")
    private String queryParentId = null;
    @JsonProperty(value="query_path")
    private String queryPath = null;
    @JsonProperty(value="query_folder")
    private String queryFolder = null;
    @JsonProperty(value="query_src")
    private String querySrc = null;
    @JsonProperty(value="query_destination")
    private String queryDestination = null;
    @JsonProperty(value="query_ip")
    private String queryIp = null;
    @JsonProperty(value="query_username")
    private String queryUsername = null;
    @JsonProperty(value="query_failure_type")
    private String queryFailureType = null;
    @JsonProperty(value="query_target_id")
    private String queryTargetId = null;
    @JsonProperty(value="query_target_name")
    private String queryTargetName = null;
    @JsonProperty(value="query_target_permission")
    private String queryTargetPermission = null;
    @JsonProperty(value="query_target_user_id")
    private String queryTargetUserId = null;
    @JsonProperty(value="query_target_username")
    private String queryTargetUsername = null;
    @JsonProperty(value="query_target_platform")
    private String queryTargetPlatform = null;
    @JsonProperty(value="query_target_permission_set")
    private String queryTargetPermissionSet = null;

    public HistoryExportsBody userId(Integer userId) {
        this.userId = userId;
        return this;
    }

    @Schema(description="User ID.  Provide a value of `0` to operate the current session's user.")
    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public HistoryExportsBody startAt(DateTime startAt) {
        this.startAt = startAt;
        return this;
    }

    @Schema(description="Start date/time of export range.")
    public DateTime getStartAt() {
        return this.startAt;
    }

    public void setStartAt(DateTime startAt) {
        this.startAt = startAt;
    }

    public HistoryExportsBody endAt(DateTime endAt) {
        this.endAt = endAt;
        return this;
    }

    @Schema(description="End date/time of export range.")
    public DateTime getEndAt() {
        return this.endAt;
    }

    public void setEndAt(DateTime endAt) {
        this.endAt = endAt;
    }

    public HistoryExportsBody queryAction(String queryAction) {
        this.queryAction = queryAction;
        return this;
    }

    @Schema(example="read", description="Filter results by this this action type. Valid values: `create`, `read`, `update`, `destroy`, `move`, `login`, `failedlogin`, `copy`, `user_create`, `user_update`, `user_destroy`, `group_create`, `group_update`, `group_destroy`, `permission_create`, `permission_destroy`, `api_key_create`, `api_key_update`, `api_key_destroy`")
    public String getQueryAction() {
        return this.queryAction;
    }

    public void setQueryAction(String queryAction) {
        this.queryAction = queryAction;
    }

    public HistoryExportsBody queryInterface(String queryInterface) {
        this.queryInterface = queryInterface;
        return this;
    }

    @Schema(example="ftp", description="Filter results by this this interface type. Valid values: `web`, `ftp`, `robot`, `jsapi`, `webdesktopapi`, `sftp`, `dav`, `desktop`, `restapi`, `scim`, `office`")
    public String getQueryInterface() {
        return this.queryInterface;
    }

    public void setQueryInterface(String queryInterface) {
        this.queryInterface = queryInterface;
    }

    public HistoryExportsBody queryUserId(String queryUserId) {
        this.queryUserId = queryUserId;
        return this;
    }

    @Schema(example="1", description="Return results that are actions performed by the user indiciated by this User ID")
    public String getQueryUserId() {
        return this.queryUserId;
    }

    public void setQueryUserId(String queryUserId) {
        this.queryUserId = queryUserId;
    }

    public HistoryExportsBody queryFileId(String queryFileId) {
        this.queryFileId = queryFileId;
        return this;
    }

    @Schema(example="1", description="Return results that are file actions related to the file indicated by this File ID")
    public String getQueryFileId() {
        return this.queryFileId;
    }

    public void setQueryFileId(String queryFileId) {
        this.queryFileId = queryFileId;
    }

    public HistoryExportsBody queryParentId(String queryParentId) {
        this.queryParentId = queryParentId;
        return this;
    }

    @Schema(example="1", description="Return results that are file actions inside the parent folder specified by this folder ID")
    public String getQueryParentId() {
        return this.queryParentId;
    }

    public void setQueryParentId(String queryParentId) {
        this.queryParentId = queryParentId;
    }

    public HistoryExportsBody queryPath(String queryPath) {
        this.queryPath = queryPath;
        return this;
    }

    @Schema(example="MyFile.txt", description="Return results that are file actions related to this path.")
    public String getQueryPath() {
        return this.queryPath;
    }

    public void setQueryPath(String queryPath) {
        this.queryPath = queryPath;
    }

    public HistoryExportsBody queryFolder(String queryFolder) {
        this.queryFolder = queryFolder;
        return this;
    }

    @Schema(example="Folder", description="Return results that are file actions related to files or folders inside this folder path.")
    public String getQueryFolder() {
        return this.queryFolder;
    }

    public void setQueryFolder(String queryFolder) {
        this.queryFolder = queryFolder;
    }

    public HistoryExportsBody querySrc(String querySrc) {
        this.querySrc = querySrc;
        return this;
    }

    @Schema(example="SrcFolder", description="Return results that are file moves originating from this path.")
    public String getQuerySrc() {
        return this.querySrc;
    }

    public void setQuerySrc(String querySrc) {
        this.querySrc = querySrc;
    }

    public HistoryExportsBody queryDestination(String queryDestination) {
        this.queryDestination = queryDestination;
        return this;
    }

    @Schema(example="DestFolder", description="Return results that are file moves with this path as destination.")
    public String getQueryDestination() {
        return this.queryDestination;
    }

    public void setQueryDestination(String queryDestination) {
        this.queryDestination = queryDestination;
    }

    public HistoryExportsBody queryIp(String queryIp) {
        this.queryIp = queryIp;
        return this;
    }

    @Schema(example="127.0.0.1", description="Filter results by this IP address.")
    public String getQueryIp() {
        return this.queryIp;
    }

    public void setQueryIp(String queryIp) {
        this.queryIp = queryIp;
    }

    public HistoryExportsBody queryUsername(String queryUsername) {
        this.queryUsername = queryUsername;
        return this;
    }

    @Schema(example="jerry", description="Filter results by this username.")
    public String getQueryUsername() {
        return this.queryUsername;
    }

    public void setQueryUsername(String queryUsername) {
        this.queryUsername = queryUsername;
    }

    public HistoryExportsBody queryFailureType(String queryFailureType) {
        this.queryFailureType = queryFailureType;
        return this;
    }

    @Schema(example="bad_password", description="If searching for Histories about login failures, this parameter restricts results to failures of this specific type.  Valid values: `expired_trial`, `account_overdue`, `locked_out`, `ip_mismatch`, `password_mismatch`, `site_mismatch`, `username_not_found`, `none`, `no_ftp_permission`, `no_web_permission`, `no_directory`, `errno_enoent`, `no_sftp_permission`, `no_dav_permission`, `no_restapi_permission`, `key_mismatch`, `region_mismatch`, `expired_access`, `desktop_ip_mismatch`, `desktop_api_key_not_used_quickly_enough`, `disabled`, `country_mismatch`")
    public String getQueryFailureType() {
        return this.queryFailureType;
    }

    public void setQueryFailureType(String queryFailureType) {
        this.queryFailureType = queryFailureType;
    }

    public HistoryExportsBody queryTargetId(String queryTargetId) {
        this.queryTargetId = queryTargetId;
        return this;
    }

    @Schema(example="1", description="If searching for Histories about specific objects (such as Users, or API Keys), this paremeter restricts results to objects that match this ID.")
    public String getQueryTargetId() {
        return this.queryTargetId;
    }

    public void setQueryTargetId(String queryTargetId) {
        this.queryTargetId = queryTargetId;
    }

    public HistoryExportsBody queryTargetName(String queryTargetName) {
        this.queryTargetName = queryTargetName;
        return this;
    }

    @Schema(example="full", description="If searching for Histories about Users, Groups or other objects with names, this parameter restricts results to objects with this name/username.")
    public String getQueryTargetName() {
        return this.queryTargetName;
    }

    public void setQueryTargetName(String queryTargetName) {
        this.queryTargetName = queryTargetName;
    }

    public HistoryExportsBody queryTargetPermission(String queryTargetPermission) {
        this.queryTargetPermission = queryTargetPermission;
        return this;
    }

    @Schema(example="full", description="If searching for Histories about Permisisons, this parameter restricts results to permissions of this level.")
    public String getQueryTargetPermission() {
        return this.queryTargetPermission;
    }

    public void setQueryTargetPermission(String queryTargetPermission) {
        this.queryTargetPermission = queryTargetPermission;
    }

    public HistoryExportsBody queryTargetUserId(String queryTargetUserId) {
        this.queryTargetUserId = queryTargetUserId;
        return this;
    }

    @Schema(example="1", description="If searching for Histories about API keys, this parameter restricts results to API keys created by/for this user ID.")
    public String getQueryTargetUserId() {
        return this.queryTargetUserId;
    }

    public void setQueryTargetUserId(String queryTargetUserId) {
        this.queryTargetUserId = queryTargetUserId;
    }

    public HistoryExportsBody queryTargetUsername(String queryTargetUsername) {
        this.queryTargetUsername = queryTargetUsername;
        return this;
    }

    @Schema(example="jerry", description="If searching for Histories about API keys, this parameter restricts results to API keys created by/for this username.")
    public String getQueryTargetUsername() {
        return this.queryTargetUsername;
    }

    public void setQueryTargetUsername(String queryTargetUsername) {
        this.queryTargetUsername = queryTargetUsername;
    }

    public HistoryExportsBody queryTargetPlatform(String queryTargetPlatform) {
        this.queryTargetPlatform = queryTargetPlatform;
        return this;
    }

    @Schema(example="windows", description="If searching for Histories about API keys, this parameter restricts results to API keys associated with this platform.")
    public String getQueryTargetPlatform() {
        return this.queryTargetPlatform;
    }

    public void setQueryTargetPlatform(String queryTargetPlatform) {
        this.queryTargetPlatform = queryTargetPlatform;
    }

    public HistoryExportsBody queryTargetPermissionSet(String queryTargetPermissionSet) {
        this.queryTargetPermissionSet = queryTargetPermissionSet;
        return this;
    }

    @Schema(example="desktop_app", description="If searching for Histories about API keys, this parameter restricts results to API keys with this permission set.")
    public String getQueryTargetPermissionSet() {
        return this.queryTargetPermissionSet;
    }

    public void setQueryTargetPermissionSet(String queryTargetPermissionSet) {
        this.queryTargetPermissionSet = queryTargetPermissionSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoryExportsBody historyExportsBody = (HistoryExportsBody)o;
        return Objects.equals(this.userId, historyExportsBody.userId) && Objects.equals(this.startAt, historyExportsBody.startAt) && Objects.equals(this.endAt, historyExportsBody.endAt) && Objects.equals(this.queryAction, historyExportsBody.queryAction) && Objects.equals(this.queryInterface, historyExportsBody.queryInterface) && Objects.equals(this.queryUserId, historyExportsBody.queryUserId) && Objects.equals(this.queryFileId, historyExportsBody.queryFileId) && Objects.equals(this.queryParentId, historyExportsBody.queryParentId) && Objects.equals(this.queryPath, historyExportsBody.queryPath) && Objects.equals(this.queryFolder, historyExportsBody.queryFolder) && Objects.equals(this.querySrc, historyExportsBody.querySrc) && Objects.equals(this.queryDestination, historyExportsBody.queryDestination) && Objects.equals(this.queryIp, historyExportsBody.queryIp) && Objects.equals(this.queryUsername, historyExportsBody.queryUsername) && Objects.equals(this.queryFailureType, historyExportsBody.queryFailureType) && Objects.equals(this.queryTargetId, historyExportsBody.queryTargetId) && Objects.equals(this.queryTargetName, historyExportsBody.queryTargetName) && Objects.equals(this.queryTargetPermission, historyExportsBody.queryTargetPermission) && Objects.equals(this.queryTargetUserId, historyExportsBody.queryTargetUserId) && Objects.equals(this.queryTargetUsername, historyExportsBody.queryTargetUsername) && Objects.equals(this.queryTargetPlatform, historyExportsBody.queryTargetPlatform) && Objects.equals(this.queryTargetPermissionSet, historyExportsBody.queryTargetPermissionSet);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.startAt, this.endAt, this.queryAction, this.queryInterface, this.queryUserId, this.queryFileId, this.queryParentId, this.queryPath, this.queryFolder, this.querySrc, this.queryDestination, this.queryIp, this.queryUsername, this.queryFailureType, this.queryTargetId, this.queryTargetName, this.queryTargetPermission, this.queryTargetUserId, this.queryTargetUsername, this.queryTargetPlatform, this.queryTargetPermissionSet);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoryExportsBody {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    startAt: ").append(this.toIndentedString(this.startAt)).append("\n");
        sb.append("    endAt: ").append(this.toIndentedString(this.endAt)).append("\n");
        sb.append("    queryAction: ").append(this.toIndentedString(this.queryAction)).append("\n");
        sb.append("    queryInterface: ").append(this.toIndentedString(this.queryInterface)).append("\n");
        sb.append("    queryUserId: ").append(this.toIndentedString(this.queryUserId)).append("\n");
        sb.append("    queryFileId: ").append(this.toIndentedString(this.queryFileId)).append("\n");
        sb.append("    queryParentId: ").append(this.toIndentedString(this.queryParentId)).append("\n");
        sb.append("    queryPath: ").append(this.toIndentedString(this.queryPath)).append("\n");
        sb.append("    queryFolder: ").append(this.toIndentedString(this.queryFolder)).append("\n");
        sb.append("    querySrc: ").append(this.toIndentedString(this.querySrc)).append("\n");
        sb.append("    queryDestination: ").append(this.toIndentedString(this.queryDestination)).append("\n");
        sb.append("    queryIp: ").append(this.toIndentedString(this.queryIp)).append("\n");
        sb.append("    queryUsername: ").append(this.toIndentedString(this.queryUsername)).append("\n");
        sb.append("    queryFailureType: ").append(this.toIndentedString(this.queryFailureType)).append("\n");
        sb.append("    queryTargetId: ").append(this.toIndentedString(this.queryTargetId)).append("\n");
        sb.append("    queryTargetName: ").append(this.toIndentedString(this.queryTargetName)).append("\n");
        sb.append("    queryTargetPermission: ").append(this.toIndentedString(this.queryTargetPermission)).append("\n");
        sb.append("    queryTargetUserId: ").append(this.toIndentedString(this.queryTargetUserId)).append("\n");
        sb.append("    queryTargetUsername: ").append(this.toIndentedString(this.queryTargetUsername)).append("\n");
        sb.append("    queryTargetPlatform: ").append(this.toIndentedString(this.queryTargetPlatform)).append("\n");
        sb.append("    queryTargetPermissionSet: ").append(this.toIndentedString(this.queryTargetPermissionSet)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

