/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="List History Export Results")
public class HistoryExportResultEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="created_at")
    private Integer createdAt = null;
    @JsonProperty(value="user_id")
    private Integer userId = null;
    @JsonProperty(value="file_id")
    private Integer fileId = null;
    @JsonProperty(value="parent_id")
    private Integer parentId = null;
    @JsonProperty(value="path")
    private String path = null;
    @JsonProperty(value="folder")
    private String folder = null;
    @JsonProperty(value="src")
    private String src = null;
    @JsonProperty(value="destination")
    private String destination = null;
    @JsonProperty(value="ip")
    private String ip = null;
    @JsonProperty(value="username")
    private String username = null;
    @JsonProperty(value="action")
    private String action = null;
    @JsonProperty(value="failure_type")
    private String failureType = null;
    @JsonProperty(value="interface")
    private String _interface = null;
    @JsonProperty(value="target_id")
    private Integer targetId = null;
    @JsonProperty(value="target_name")
    private String targetName = null;
    @JsonProperty(value="target_permission")
    private String targetPermission = null;
    @JsonProperty(value="target_recursive")
    private Boolean targetRecursive = null;
    @JsonProperty(value="target_expires_at")
    private Integer targetExpiresAt = null;
    @JsonProperty(value="target_permission_set")
    private String targetPermissionSet = null;
    @JsonProperty(value="target_platform")
    private String targetPlatform = null;
    @JsonProperty(value="target_username")
    private String targetUsername = null;
    @JsonProperty(value="target_user_id")
    private Integer targetUserId = null;

    public HistoryExportResultEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="Action ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public HistoryExportResultEntity createdAt(Integer createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(example="1", description="When the action happened")
    public Integer getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Integer createdAt) {
        this.createdAt = createdAt;
    }

    public HistoryExportResultEntity userId(Integer userId) {
        this.userId = userId;
        return this;
    }

    @Schema(example="1", description="User ID")
    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public HistoryExportResultEntity fileId(Integer fileId) {
        this.fileId = fileId;
        return this;
    }

    @Schema(example="1", description="File ID related to the action")
    public Integer getFileId() {
        return this.fileId;
    }

    public void setFileId(Integer fileId) {
        this.fileId = fileId;
    }

    public HistoryExportResultEntity parentId(Integer parentId) {
        this.parentId = parentId;
        return this;
    }

    @Schema(example="1", description="ID of the parent folder")
    public Integer getParentId() {
        return this.parentId;
    }

    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    public HistoryExportResultEntity path(String path) {
        this.path = path;
        return this;
    }

    @Schema(example="MyFile.txt", description="Path of the related action")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public HistoryExportResultEntity folder(String folder) {
        this.folder = folder;
        return this;
    }

    @Schema(example="Folder", description="Folder in which the action occurred")
    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public HistoryExportResultEntity src(String src) {
        this.src = src;
        return this;
    }

    @Schema(example="SrcFolder", description="File move originated from this path")
    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public HistoryExportResultEntity destination(String destination) {
        this.destination = destination;
        return this;
    }

    @Schema(example="DestFolder", description="File moved to this destination folder")
    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public HistoryExportResultEntity ip(String ip) {
        this.ip = ip;
        return this;
    }

    @Schema(example="127.0.0.1", description="Client IP that performed the action")
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public HistoryExportResultEntity username(String username) {
        this.username = username;
        return this;
    }

    @Schema(example="jerry", description="Username of the user that performed the action")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public HistoryExportResultEntity action(String action) {
        this.action = action;
        return this;
    }

    @Schema(example="read", description="What action was taken. Valid values: `create`, `read`, `update`, `destroy`, `move`, `login`, `failedlogin`, `copy`, `user_create`, `user_update`, `user_destroy`, `group_create`, `group_update`, `group_destroy`, `permission_create`, `permission_destroy`, `api_key_create`, `api_key_update`, `api_key_destroy`")
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public HistoryExportResultEntity failureType(String failureType) {
        this.failureType = failureType;
        return this;
    }

    @Schema(example="bad_password", description="The type of login failure, if applicable.  Valid values: `expired_trial`, `account_overdue`, `locked_out`, `ip_mismatch`, `password_mismatch`, `site_mismatch`, `username_not_found`, `none`, `no_ftp_permission`, `no_web_permission`, `no_directory`, `errno_enoent`, `no_sftp_permission`, `no_dav_permission`, `no_restapi_permission`, `key_mismatch`, `region_mismatch`, `expired_access`, `desktop_ip_mismatch`, `desktop_api_key_not_used_quickly_enough`, `disabled`, `country_mismatch`")
    public String getFailureType() {
        return this.failureType;
    }

    public void setFailureType(String failureType) {
        this.failureType = failureType;
    }

    public HistoryExportResultEntity _interface(String _interface) {
        this._interface = _interface;
        return this;
    }

    @Schema(example="ftp", description="Inteface through which the action was taken. Valid values: `web`, `ftp`, `robot`, `jsapi`, `webdesktopapi`, `sftp`, `dav`, `desktop`, `restapi`, `scim`, `office`")
    public String getInterface() {
        return this._interface;
    }

    public void setInterface(String _interface) {
        this._interface = _interface;
    }

    public HistoryExportResultEntity targetId(Integer targetId) {
        this.targetId = targetId;
        return this;
    }

    @Schema(example="1", description="ID of the object (such as Users, or API Keys) on which the action was taken")
    public Integer getTargetId() {
        return this.targetId;
    }

    public void setTargetId(Integer targetId) {
        this.targetId = targetId;
    }

    public HistoryExportResultEntity targetName(String targetName) {
        this.targetName = targetName;
        return this;
    }

    @Schema(example="full", description="Name of the User, Group or other object with a name related to this action")
    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public HistoryExportResultEntity targetPermission(String targetPermission) {
        this.targetPermission = targetPermission;
        return this;
    }

    @Schema(example="full", description="Permission level of the action")
    public String getTargetPermission() {
        return this.targetPermission;
    }

    public void setTargetPermission(String targetPermission) {
        this.targetPermission = targetPermission;
    }

    public HistoryExportResultEntity targetRecursive(Boolean targetRecursive) {
        this.targetRecursive = targetRecursive;
        return this;
    }

    @Schema(example="true", description="Whether or not the action was recursive")
    public Boolean isTargetRecursive() {
        return this.targetRecursive;
    }

    public void setTargetRecursive(Boolean targetRecursive) {
        this.targetRecursive = targetRecursive;
    }

    public HistoryExportResultEntity targetExpiresAt(Integer targetExpiresAt) {
        this.targetExpiresAt = targetExpiresAt;
        return this;
    }

    @Schema(example="1", description="If searching for Histories about API keys, this is when the API key will expire")
    public Integer getTargetExpiresAt() {
        return this.targetExpiresAt;
    }

    public void setTargetExpiresAt(Integer targetExpiresAt) {
        this.targetExpiresAt = targetExpiresAt;
    }

    public HistoryExportResultEntity targetPermissionSet(String targetPermissionSet) {
        this.targetPermissionSet = targetPermissionSet;
        return this;
    }

    @Schema(example="desktop_app", description="If searching for Histories about API keys, this represents the permission set of the associated  API key")
    public String getTargetPermissionSet() {
        return this.targetPermissionSet;
    }

    public void setTargetPermissionSet(String targetPermissionSet) {
        this.targetPermissionSet = targetPermissionSet;
    }

    public HistoryExportResultEntity targetPlatform(String targetPlatform) {
        this.targetPlatform = targetPlatform;
        return this;
    }

    @Schema(example="windows", description="If searching for Histories about API keys, this is the platform on which the action was taken")
    public String getTargetPlatform() {
        return this.targetPlatform;
    }

    public void setTargetPlatform(String targetPlatform) {
        this.targetPlatform = targetPlatform;
    }

    public HistoryExportResultEntity targetUsername(String targetUsername) {
        this.targetUsername = targetUsername;
        return this;
    }

    @Schema(example="jerry", description="If searching for Histories about API keys, this is the username on which the action was taken")
    public String getTargetUsername() {
        return this.targetUsername;
    }

    public void setTargetUsername(String targetUsername) {
        this.targetUsername = targetUsername;
    }

    public HistoryExportResultEntity targetUserId(Integer targetUserId) {
        this.targetUserId = targetUserId;
        return this;
    }

    @Schema(example="1", description="If searching for Histories about API keys, this is the User ID on which the action was taken")
    public Integer getTargetUserId() {
        return this.targetUserId;
    }

    public void setTargetUserId(Integer targetUserId) {
        this.targetUserId = targetUserId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoryExportResultEntity historyExportResultEntity = (HistoryExportResultEntity)o;
        return Objects.equals(this.id, historyExportResultEntity.id) && Objects.equals(this.createdAt, historyExportResultEntity.createdAt) && Objects.equals(this.userId, historyExportResultEntity.userId) && Objects.equals(this.fileId, historyExportResultEntity.fileId) && Objects.equals(this.parentId, historyExportResultEntity.parentId) && Objects.equals(this.path, historyExportResultEntity.path) && Objects.equals(this.folder, historyExportResultEntity.folder) && Objects.equals(this.src, historyExportResultEntity.src) && Objects.equals(this.destination, historyExportResultEntity.destination) && Objects.equals(this.ip, historyExportResultEntity.ip) && Objects.equals(this.username, historyExportResultEntity.username) && Objects.equals(this.action, historyExportResultEntity.action) && Objects.equals(this.failureType, historyExportResultEntity.failureType) && Objects.equals(this._interface, historyExportResultEntity._interface) && Objects.equals(this.targetId, historyExportResultEntity.targetId) && Objects.equals(this.targetName, historyExportResultEntity.targetName) && Objects.equals(this.targetPermission, historyExportResultEntity.targetPermission) && Objects.equals(this.targetRecursive, historyExportResultEntity.targetRecursive) && Objects.equals(this.targetExpiresAt, historyExportResultEntity.targetExpiresAt) && Objects.equals(this.targetPermissionSet, historyExportResultEntity.targetPermissionSet) && Objects.equals(this.targetPlatform, historyExportResultEntity.targetPlatform) && Objects.equals(this.targetUsername, historyExportResultEntity.targetUsername) && Objects.equals(this.targetUserId, historyExportResultEntity.targetUserId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.userId, this.fileId, this.parentId, this.path, this.folder, this.src, this.destination, this.ip, this.username, this.action, this.failureType, this._interface, this.targetId, this.targetName, this.targetPermission, this.targetRecursive, this.targetExpiresAt, this.targetPermissionSet, this.targetPlatform, this.targetUsername, this.targetUserId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoryExportResultEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    fileId: ").append(this.toIndentedString(this.fileId)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    folder: ").append(this.toIndentedString(this.folder)).append("\n");
        sb.append("    src: ").append(this.toIndentedString(this.src)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    failureType: ").append(this.toIndentedString(this.failureType)).append("\n");
        sb.append("    _interface: ").append(this.toIndentedString(this._interface)).append("\n");
        sb.append("    targetId: ").append(this.toIndentedString(this.targetId)).append("\n");
        sb.append("    targetName: ").append(this.toIndentedString(this.targetName)).append("\n");
        sb.append("    targetPermission: ").append(this.toIndentedString(this.targetPermission)).append("\n");
        sb.append("    targetRecursive: ").append(this.toIndentedString(this.targetRecursive)).append("\n");
        sb.append("    targetExpiresAt: ").append(this.toIndentedString(this.targetExpiresAt)).append("\n");
        sb.append("    targetPermissionSet: ").append(this.toIndentedString(this.targetPermissionSet)).append("\n");
        sb.append("    targetPlatform: ").append(this.toIndentedString(this.targetPlatform)).append("\n");
        sb.append("    targetUsername: ").append(this.toIndentedString(this.targetUsername)).append("\n");
        sb.append("    targetUserId: ").append(this.toIndentedString(this.targetUserId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

