/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Create Group User")
public class GroupUserEntity {
    @JsonProperty(value="group_name")
    private String groupName = null;
    @JsonProperty(value="group_id")
    private Integer groupId = null;
    @JsonProperty(value="user_id")
    private Integer userId = null;
    @JsonProperty(value="admin")
    private Boolean admin = null;
    @JsonProperty(value="usernames")
    private List<String> usernames = null;

    public GroupUserEntity groupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    @Schema(example="My Group", description="Group name")
    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public GroupUserEntity groupId(Integer groupId) {
        this.groupId = groupId;
        return this;
    }

    @Schema(example="1", description="Group ID")
    public Integer getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Integer groupId) {
        this.groupId = groupId;
    }

    public GroupUserEntity userId(Integer userId) {
        this.userId = userId;
        return this;
    }

    @Schema(example="1", description="User ID")
    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public GroupUserEntity admin(Boolean admin) {
        this.admin = admin;
        return this;
    }

    @Schema(example="true", description="Is this user an administrator of this group?")
    public Boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(Boolean admin) {
        this.admin = admin;
    }

    public GroupUserEntity usernames(List<String> usernames) {
        this.usernames = usernames;
        return this;
    }

    public GroupUserEntity addUsernamesItem(String usernamesItem) {
        if (this.usernames == null) {
            this.usernames = new ArrayList<String>();
        }
        this.usernames.add(usernamesItem);
        return this;
    }

    @Schema(example="[\"user\"]", description="A list of usernames for users in this group")
    public List<String> getUsernames() {
        return this.usernames;
    }

    public void setUsernames(List<String> usernames) {
        this.usernames = usernames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupUserEntity groupUserEntity = (GroupUserEntity)o;
        return Objects.equals(this.groupName, groupUserEntity.groupName) && Objects.equals(this.groupId, groupUserEntity.groupId) && Objects.equals(this.userId, groupUserEntity.userId) && Objects.equals(this.admin, groupUserEntity.admin) && Objects.equals(this.usernames, groupUserEntity.usernames);
    }

    public int hashCode() {
        return Objects.hash(this.groupName, this.groupId, this.userId, this.admin, this.usernames);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupUserEntity {\n");
        sb.append("    groupName: ").append(this.toIndentedString(this.groupName)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    admin: ").append(this.toIndentedString(this.admin)).append("\n");
        sb.append("    usernames: ").append(this.toIndentedString(this.usernames)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

