/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="List Groups")
public class GroupEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="admin_ids")
    private String adminIds = null;
    @JsonProperty(value="notes")
    private String notes = null;
    @JsonProperty(value="user_ids")
    private List<Integer> userIds = null;
    @JsonProperty(value="usernames")
    private List<String> usernames = null;

    public GroupEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="Group ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public GroupEntity name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="owners", description="Group name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GroupEntity adminIds(String adminIds) {
        this.adminIds = adminIds;
        return this;
    }

    @Schema(description="List of user IDs who are group administrators (separated by commas)")
    public String getAdminIds() {
        return this.adminIds;
    }

    public void setAdminIds(String adminIds) {
        this.adminIds = adminIds;
    }

    public GroupEntity notes(String notes) {
        this.notes = notes;
        return this;
    }

    @Schema(description="Notes about this group")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public GroupEntity userIds(List<Integer> userIds) {
        this.userIds = userIds;
        return this;
    }

    public GroupEntity addUserIdsItem(Integer userIdsItem) {
        if (this.userIds == null) {
            this.userIds = new ArrayList<Integer>();
        }
        this.userIds.add(userIdsItem);
        return this;
    }

    @Schema(example="[1]", description="List of user IDs who belong to this group (separated by commas)")
    public List<Integer> getUserIds() {
        return this.userIds;
    }

    public void setUserIds(List<Integer> userIds) {
        this.userIds = userIds;
    }

    public GroupEntity usernames(List<String> usernames) {
        this.usernames = usernames;
        return this;
    }

    public GroupEntity addUsernamesItem(String usernamesItem) {
        if (this.usernames == null) {
            this.usernames = new ArrayList<String>();
        }
        this.usernames.add(usernamesItem);
        return this;
    }

    @Schema(example="[\"user\"]", description="List of usernames who belong to this group (separated by commas)")
    public List<String> getUsernames() {
        return this.usernames;
    }

    public void setUsernames(List<String> usernames) {
        this.usernames = usernames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupEntity groupEntity = (GroupEntity)o;
        return Objects.equals(this.id, groupEntity.id) && Objects.equals(this.name, groupEntity.name) && Objects.equals(this.adminIds, groupEntity.adminIds) && Objects.equals(this.notes, groupEntity.notes) && Objects.equals(this.userIds, groupEntity.userIds) && Objects.equals(this.usernames, groupEntity.usernames);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.adminIds, this.notes, this.userIds, this.usernames);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    adminIds: ").append(this.toIndentedString(this.adminIds)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    userIds: ").append(this.toIndentedString(this.userIds)).append("\n");
        sb.append("    usernames: ").append(this.toIndentedString(this.usernames)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

