/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class FormFieldEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="label")
    private String label = null;
    @JsonProperty(value="required")
    private Boolean required = null;
    @JsonProperty(value="help_text")
    private String helpText = null;
    @JsonProperty(value="field_type")
    private FieldTypeEnum fieldType = null;
    @JsonProperty(value="options_for_select")
    private String optionsForSelect = null;
    @JsonProperty(value="default_option")
    private String defaultOption = null;
    @JsonProperty(value="form_field_set_id")
    private Integer formFieldSetId = null;

    public FormFieldEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="Form field id")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public FormFieldEntity label(String label) {
        this.label = label;
        return this;
    }

    @Schema(example="Sample Label", description="Label to be displayed")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public FormFieldEntity required(Boolean required) {
        this.required = required;
        return this;
    }

    @Schema(example="true", description="Is this a required field?")
    public Boolean isRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public FormFieldEntity helpText(String helpText) {
        this.helpText = helpText;
        return this;
    }

    @Schema(example="Help Text", description="Help text to be displayed")
    public String getHelpText() {
        return this.helpText;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    public FormFieldEntity fieldType(FieldTypeEnum fieldType) {
        this.fieldType = fieldType;
        return this;
    }

    @Schema(example="text", description="Type of Field")
    public FieldTypeEnum getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(FieldTypeEnum fieldType) {
        this.fieldType = fieldType;
    }

    public FormFieldEntity optionsForSelect(String optionsForSelect) {
        this.optionsForSelect = optionsForSelect;
        return this;
    }

    @Schema(description="Options to display for radio and dropdown")
    public String getOptionsForSelect() {
        return this.optionsForSelect;
    }

    public void setOptionsForSelect(String optionsForSelect) {
        this.optionsForSelect = optionsForSelect;
    }

    public FormFieldEntity defaultOption(String defaultOption) {
        this.defaultOption = defaultOption;
        return this;
    }

    @Schema(example="red", description="Default option for radio and dropdown")
    public String getDefaultOption() {
        return this.defaultOption;
    }

    public void setDefaultOption(String defaultOption) {
        this.defaultOption = defaultOption;
    }

    public FormFieldEntity formFieldSetId(Integer formFieldSetId) {
        this.formFieldSetId = formFieldSetId;
        return this;
    }

    @Schema(example="1", description="Form field set id")
    public Integer getFormFieldSetId() {
        return this.formFieldSetId;
    }

    public void setFormFieldSetId(Integer formFieldSetId) {
        this.formFieldSetId = formFieldSetId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormFieldEntity formFieldEntity = (FormFieldEntity)o;
        return Objects.equals(this.id, formFieldEntity.id) && Objects.equals(this.label, formFieldEntity.label) && Objects.equals(this.required, formFieldEntity.required) && Objects.equals(this.helpText, formFieldEntity.helpText) && Objects.equals((Object)this.fieldType, (Object)formFieldEntity.fieldType) && Objects.equals(this.optionsForSelect, formFieldEntity.optionsForSelect) && Objects.equals(this.defaultOption, formFieldEntity.defaultOption) && Objects.equals(this.formFieldSetId, formFieldEntity.formFieldSetId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.label, this.required, this.helpText, this.fieldType, this.optionsForSelect, this.defaultOption, this.formFieldSetId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FormFieldEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    required: ").append(this.toIndentedString(this.required)).append("\n");
        sb.append("    helpText: ").append(this.toIndentedString(this.helpText)).append("\n");
        sb.append("    fieldType: ").append(this.toIndentedString((Object)this.fieldType)).append("\n");
        sb.append("    optionsForSelect: ").append(this.toIndentedString(this.optionsForSelect)).append("\n");
        sb.append("    defaultOption: ").append(this.toIndentedString(this.defaultOption)).append("\n");
        sb.append("    formFieldSetId: ").append(this.toIndentedString(this.formFieldSetId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FieldTypeEnum {
        TEXT("text"),
        TEXT_AREA("text_area"),
        DROPDOWN("dropdown"),
        RADIO("radio");

        private String value;

        private FieldTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FieldTypeEnum fromValue(String text) {
            for (FieldTypeEnum b : FieldTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

