/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Begin file upload")
public class FileUploadPartEntity {
    @JsonProperty(value="send")
    private Object send = null;
    @JsonProperty(value="action")
    private String action = null;
    @JsonProperty(value="ask_about_overwrites")
    private Boolean askAboutOverwrites = null;
    @JsonProperty(value="available_parts")
    private Integer availableParts = null;
    @JsonProperty(value="expires")
    private String expires = null;
    @JsonProperty(value="headers")
    private Object headers = null;
    @JsonProperty(value="http_method")
    private String httpMethod = null;
    @JsonProperty(value="next_partsize")
    private Integer nextPartsize = null;
    @JsonProperty(value="parallel_parts")
    private Boolean parallelParts = null;
    @JsonProperty(value="parameters")
    private Object parameters = null;
    @JsonProperty(value="part_number")
    private Integer partNumber = null;
    @JsonProperty(value="partsize")
    private Integer partsize = null;
    @JsonProperty(value="path")
    private String path = null;
    @JsonProperty(value="ref")
    private String ref = null;
    @JsonProperty(value="upload_uri")
    private String uploadUri = null;

    public FileUploadPartEntity send(Object send) {
        this.send = send;
        return this;
    }

    @Schema(example="{}", description="Content-Type and File to send")
    public Object getSend() {
        return this.send;
    }

    public void setSend(Object send) {
        this.send = send;
    }

    public FileUploadPartEntity action(String action) {
        this.action = action;
        return this;
    }

    @Schema(example="multipart", description="Type of upload")
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public FileUploadPartEntity askAboutOverwrites(Boolean askAboutOverwrites) {
        this.askAboutOverwrites = askAboutOverwrites;
        return this;
    }

    @Schema(example="true", description="If `true`, this file exists and you may wish to ask the user for overwrite confirmation")
    public Boolean isAskAboutOverwrites() {
        return this.askAboutOverwrites;
    }

    public void setAskAboutOverwrites(Boolean askAboutOverwrites) {
        this.askAboutOverwrites = askAboutOverwrites;
    }

    public FileUploadPartEntity availableParts(Integer availableParts) {
        this.availableParts = availableParts;
        return this;
    }

    @Schema(example="1", description="Number of parts in the upload")
    public Integer getAvailableParts() {
        return this.availableParts;
    }

    public void setAvailableParts(Integer availableParts) {
        this.availableParts = availableParts;
    }

    public FileUploadPartEntity expires(String expires) {
        this.expires = expires;
        return this;
    }

    @Schema(description="Date/time of when this Upload part expires and the URL cannot be used any more")
    public String getExpires() {
        return this.expires;
    }

    public void setExpires(String expires) {
        this.expires = expires;
    }

    public FileUploadPartEntity headers(Object headers) {
        this.headers = headers;
        return this;
    }

    @Schema(example="{}", description="Additional upload headers to provide as part of the upload")
    public Object getHeaders() {
        return this.headers;
    }

    public void setHeaders(Object headers) {
        this.headers = headers;
    }

    public FileUploadPartEntity httpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    @Schema(example="PUT", description="HTTP Method to use for uploading the part, usually `PUT`")
    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public FileUploadPartEntity nextPartsize(Integer nextPartsize) {
        this.nextPartsize = nextPartsize;
        return this;
    }

    @Schema(example="1", description="Size in bytes for this part")
    public Integer getNextPartsize() {
        return this.nextPartsize;
    }

    public void setNextPartsize(Integer nextPartsize) {
        this.nextPartsize = nextPartsize;
    }

    public FileUploadPartEntity parallelParts(Boolean parallelParts) {
        this.parallelParts = parallelParts;
        return this;
    }

    @Schema(example="true", description="If `true`, multiple parts may be uploaded in parallel.  If `false`, be sure to only upload one part at a time, in order.")
    public Boolean isParallelParts() {
        return this.parallelParts;
    }

    public void setParallelParts(Boolean parallelParts) {
        this.parallelParts = parallelParts;
    }

    public FileUploadPartEntity parameters(Object parameters) {
        this.parameters = parameters;
        return this;
    }

    @Schema(example="{}", description="Additional HTTP parameters to send with the upload")
    public Object getParameters() {
        return this.parameters;
    }

    public void setParameters(Object parameters) {
        this.parameters = parameters;
    }

    public FileUploadPartEntity partNumber(Integer partNumber) {
        this.partNumber = partNumber;
        return this;
    }

    @Schema(example="1", description="Number of this upload part")
    public Integer getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(Integer partNumber) {
        this.partNumber = partNumber;
    }

    public FileUploadPartEntity partsize(Integer partsize) {
        this.partsize = partsize;
        return this;
    }

    @Schema(example="1", description="Size in bytes for the next upload part")
    public Integer getPartsize() {
        return this.partsize;
    }

    public void setPartsize(Integer partsize) {
        this.partsize = partsize;
    }

    public FileUploadPartEntity path(String path) {
        this.path = path;
        return this;
    }

    @Schema(example="path", description="New file path")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public FileUploadPartEntity ref(String ref) {
        this.ref = ref;
        return this;
    }

    @Schema(example="upload-1", description="Reference name for this upload part")
    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public FileUploadPartEntity uploadUri(String uploadUri) {
        this.uploadUri = uploadUri;
        return this;
    }

    @Schema(description="URI to upload this part to")
    public String getUploadUri() {
        return this.uploadUri;
    }

    public void setUploadUri(String uploadUri) {
        this.uploadUri = uploadUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileUploadPartEntity fileUploadPartEntity = (FileUploadPartEntity)o;
        return Objects.equals(this.send, fileUploadPartEntity.send) && Objects.equals(this.action, fileUploadPartEntity.action) && Objects.equals(this.askAboutOverwrites, fileUploadPartEntity.askAboutOverwrites) && Objects.equals(this.availableParts, fileUploadPartEntity.availableParts) && Objects.equals(this.expires, fileUploadPartEntity.expires) && Objects.equals(this.headers, fileUploadPartEntity.headers) && Objects.equals(this.httpMethod, fileUploadPartEntity.httpMethod) && Objects.equals(this.nextPartsize, fileUploadPartEntity.nextPartsize) && Objects.equals(this.parallelParts, fileUploadPartEntity.parallelParts) && Objects.equals(this.parameters, fileUploadPartEntity.parameters) && Objects.equals(this.partNumber, fileUploadPartEntity.partNumber) && Objects.equals(this.partsize, fileUploadPartEntity.partsize) && Objects.equals(this.path, fileUploadPartEntity.path) && Objects.equals(this.ref, fileUploadPartEntity.ref) && Objects.equals(this.uploadUri, fileUploadPartEntity.uploadUri);
    }

    public int hashCode() {
        return Objects.hash(this.send, this.action, this.askAboutOverwrites, this.availableParts, this.expires, this.headers, this.httpMethod, this.nextPartsize, this.parallelParts, this.parameters, this.partNumber, this.partsize, this.path, this.ref, this.uploadUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FileUploadPartEntity {\n");
        sb.append("    send: ").append(this.toIndentedString(this.send)).append("\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    askAboutOverwrites: ").append(this.toIndentedString(this.askAboutOverwrites)).append("\n");
        sb.append("    availableParts: ").append(this.toIndentedString(this.availableParts)).append("\n");
        sb.append("    expires: ").append(this.toIndentedString(this.expires)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    httpMethod: ").append(this.toIndentedString(this.httpMethod)).append("\n");
        sb.append("    nextPartsize: ").append(this.toIndentedString(this.nextPartsize)).append("\n");
        sb.append("    parallelParts: ").append(this.toIndentedString(this.parallelParts)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    partNumber: ").append(this.toIndentedString(this.partNumber)).append("\n");
        sb.append("    partsize: ").append(this.toIndentedString(this.partsize)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    ref: ").append(this.toIndentedString(this.ref)).append("\n");
        sb.append("    uploadUri: ").append(this.toIndentedString(this.uploadUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

