/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Show File Migration")
public class FileMigrationEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="path")
    private String path = null;
    @JsonProperty(value="dest_path")
    private String destPath = null;
    @JsonProperty(value="files_moved")
    private Integer filesMoved = null;
    @JsonProperty(value="files_total")
    private Integer filesTotal = null;
    @JsonProperty(value="operation")
    private OperationEnum operation = null;
    @JsonProperty(value="region")
    private String region = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="log_url")
    private String logUrl = null;

    public FileMigrationEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="File migration ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public FileMigrationEntity path(String path) {
        this.path = path;
        return this;
    }

    @Schema(example="MyFolder", description="Source path")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public FileMigrationEntity destPath(String destPath) {
        this.destPath = destPath;
        return this;
    }

    @Schema(example="MyFolder", description="Destination path")
    public String getDestPath() {
        return this.destPath;
    }

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    public FileMigrationEntity filesMoved(Integer filesMoved) {
        this.filesMoved = filesMoved;
        return this;
    }

    @Schema(example="1", description="Number of files processed")
    public Integer getFilesMoved() {
        return this.filesMoved;
    }

    public void setFilesMoved(Integer filesMoved) {
        this.filesMoved = filesMoved;
    }

    public FileMigrationEntity filesTotal(Integer filesTotal) {
        this.filesTotal = filesTotal;
        return this;
    }

    @Schema(example="1", description="Total number of files to process")
    public Integer getFilesTotal() {
        return this.filesTotal;
    }

    public void setFilesTotal(Integer filesTotal) {
        this.filesTotal = filesTotal;
    }

    public FileMigrationEntity operation(OperationEnum operation) {
        this.operation = operation;
        return this;
    }

    @Schema(example="move", description="The type of operation")
    public OperationEnum getOperation() {
        return this.operation;
    }

    public void setOperation(OperationEnum operation) {
        this.operation = operation;
    }

    public FileMigrationEntity region(String region) {
        this.region = region;
        return this;
    }

    @Schema(example="USA", description="Region")
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public FileMigrationEntity status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Schema(example="complete", description="Status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public FileMigrationEntity logUrl(String logUrl) {
        this.logUrl = logUrl;
        return this;
    }

    @Schema(example="https://www.example.com/log_file", description="Link to download the log file for this migration.")
    public String getLogUrl() {
        return this.logUrl;
    }

    public void setLogUrl(String logUrl) {
        this.logUrl = logUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileMigrationEntity fileMigrationEntity = (FileMigrationEntity)o;
        return Objects.equals(this.id, fileMigrationEntity.id) && Objects.equals(this.path, fileMigrationEntity.path) && Objects.equals(this.destPath, fileMigrationEntity.destPath) && Objects.equals(this.filesMoved, fileMigrationEntity.filesMoved) && Objects.equals(this.filesTotal, fileMigrationEntity.filesTotal) && Objects.equals((Object)this.operation, (Object)fileMigrationEntity.operation) && Objects.equals(this.region, fileMigrationEntity.region) && Objects.equals((Object)this.status, (Object)fileMigrationEntity.status) && Objects.equals(this.logUrl, fileMigrationEntity.logUrl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.path, this.destPath, this.filesMoved, this.filesTotal, this.operation, this.region, this.status, this.logUrl});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FileMigrationEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    destPath: ").append(this.toIndentedString(this.destPath)).append("\n");
        sb.append("    filesMoved: ").append(this.toIndentedString(this.filesMoved)).append("\n");
        sb.append("    filesTotal: ").append(this.toIndentedString(this.filesTotal)).append("\n");
        sb.append("    operation: ").append(this.toIndentedString((Object)this.operation)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    logUrl: ").append(this.toIndentedString(this.logUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OperationEnum {
        DELETE("delete"),
        MOVE("move"),
        COPY("copy"),
        REGIONAL_MIGRATION("regional_migration");

        private String value;

        private OperationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperationEnum fromValue(String text) {
            for (OperationEnum b : OperationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum StatusEnum {
        PENDING("pending"),
        COUNTING("counting"),
        PROCESSING("processing"),
        COMPLETED("completed"),
        PROCESSING_SUBFOLDERS("processing_subfolders"),
        FINISHING("finishing"),
        CREATING_DEST_FOLDER("creating_dest_folder"),
        WAITING_FOR_OTHER_JOBS("waiting_for_other_jobs"),
        WAITING_FOR_ALL_FILES("waiting_for_all_files"),
        WAITING_FOR_PENDING_SUBFOLDERS("waiting_for_pending_subfolders"),
        WAITING_FOR_ALL_SUBFOLDERS("waiting_for_all_subfolders"),
        FAILED("failed"),
        WAITING_FOR_ENQUEUED_OPERATIONS("waiting_for_enqueued_operations"),
        UNUSED("unused"),
        PROCESSING_RECURSIVELY("processing_recursively"),
        REMOVING_DEFERRED_FOLDERS("removing_deferred_folders");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

