/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import ch.cyberduck.core.brick.io.swagger.client.model.PreviewEntity;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="List Folders by path")
public class FileEntity {
    @JsonProperty(value="path")
    private String path = null;
    @JsonProperty(value="display_name")
    private String displayName = null;
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="size")
    private Long size = null;
    @JsonProperty(value="mtime")
    private DateTime mtime = null;
    @JsonProperty(value="provided_mtime")
    private DateTime providedMtime = null;
    @JsonProperty(value="crc32")
    private String crc32 = null;
    @JsonProperty(value="md5")
    private String md5 = null;
    @JsonProperty(value="mime_type")
    private String mimeType = null;
    @JsonProperty(value="region")
    private String region = null;
    @JsonProperty(value="permissions")
    private String permissions = null;
    @JsonProperty(value="subfolders_locked?")
    private Boolean subfoldersLocked = null;
    @JsonProperty(value="download_uri")
    private String downloadUri = null;
    @JsonProperty(value="priority_color")
    private String priorityColor = null;
    @JsonProperty(value="preview_id")
    private Integer previewId = null;
    @JsonProperty(value="preview")
    private PreviewEntity preview = null;

    public FileEntity path(String path) {
        this.path = path;
        return this;
    }

    @Schema(example="path/file.txt", description="File/Folder path")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public FileEntity displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Schema(example="file.txt", description="File/Folder display name")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public FileEntity type(String type) {
        this.type = type;
        return this;
    }

    @Schema(example="file", description="Type: `directory` or `file`.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public FileEntity size(Long size) {
        this.size = size;
        return this;
    }

    @Schema(example="1024", description="File/Folder size")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public FileEntity mtime(DateTime mtime) {
        this.mtime = mtime;
        return this;
    }

    @Schema(description="File last modified date/time, according to the server.  This is the timestamp of the last Files.com operation of the file, regardless of what modified timestamp was sent.")
    public DateTime getMtime() {
        return this.mtime;
    }

    public void setMtime(DateTime mtime) {
        this.mtime = mtime;
    }

    public FileEntity providedMtime(DateTime providedMtime) {
        this.providedMtime = providedMtime;
        return this;
    }

    @Schema(description="File last modified date/time, according to the client who set it.  Files.com allows desktop, FTP, SFTP, and WebDAV clients to set modified at times.  This allows Desktop<->Cloud syncing to preserve modified at times.")
    public DateTime getProvidedMtime() {
        return this.providedMtime;
    }

    public void setProvidedMtime(DateTime providedMtime) {
        this.providedMtime = providedMtime;
    }

    public FileEntity crc32(String crc32) {
        this.crc32 = crc32;
        return this;
    }

    @Schema(example="70976923", description="File CRC32 checksum. This is sometimes delayed, so if you get a blank response, wait and try again.")
    public String getCrc32() {
        return this.crc32;
    }

    public void setCrc32(String crc32) {
        this.crc32 = crc32;
    }

    public FileEntity md5(String md5) {
        this.md5 = md5;
        return this;
    }

    @Schema(example="17c54824e9931a4688ca032d03f6663c", description="File MD5 checksum. This is sometimes delayed, so if you get a blank response, wait and try again.")
    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public FileEntity mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    @Schema(example="application/octet-stream", description="MIME Type.  This is determined by the filename extension and is not stored separately internally.")
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public FileEntity region(String region) {
        this.region = region;
        return this;
    }

    @Schema(example="us-east-1", description="Region location")
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public FileEntity permissions(String permissions) {
        this.permissions = permissions;
        return this;
    }

    @Schema(example="rpw", description="A short string representing the current user's permissions.  Can be `r`,`w`,`p`, or any combination")
    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public FileEntity subfoldersLocked(Boolean subfoldersLocked) {
        this.subfoldersLocked = subfoldersLocked;
        return this;
    }

    @Schema(example="true", description="Are subfolders locked and unable to be modified?")
    public Boolean isSubfoldersLocked() {
        return this.subfoldersLocked;
    }

    public void setSubfoldersLocked(Boolean subfoldersLocked) {
        this.subfoldersLocked = subfoldersLocked;
    }

    public FileEntity downloadUri(String downloadUri) {
        this.downloadUri = downloadUri;
        return this;
    }

    @Schema(example="https://mysite.files.com/...", description="Link to download file. Provided only in response to a download request.")
    public String getDownloadUri() {
        return this.downloadUri;
    }

    public void setDownloadUri(String downloadUri) {
        this.downloadUri = downloadUri;
    }

    public FileEntity priorityColor(String priorityColor) {
        this.priorityColor = priorityColor;
        return this;
    }

    @Schema(example="red", description="Bookmark/priority color of file/folder")
    public String getPriorityColor() {
        return this.priorityColor;
    }

    public void setPriorityColor(String priorityColor) {
        this.priorityColor = priorityColor;
    }

    public FileEntity previewId(Integer previewId) {
        this.previewId = previewId;
        return this;
    }

    @Schema(example="1", description="File preview ID")
    public Integer getPreviewId() {
        return this.previewId;
    }

    public void setPreviewId(Integer previewId) {
        this.previewId = previewId;
    }

    public FileEntity preview(PreviewEntity preview) {
        this.preview = preview;
        return this;
    }

    @Schema(description="")
    public PreviewEntity getPreview() {
        return this.preview;
    }

    public void setPreview(PreviewEntity preview) {
        this.preview = preview;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileEntity fileEntity = (FileEntity)o;
        return Objects.equals(this.path, fileEntity.path) && Objects.equals(this.displayName, fileEntity.displayName) && Objects.equals(this.type, fileEntity.type) && Objects.equals(this.size, fileEntity.size) && Objects.equals(this.mtime, fileEntity.mtime) && Objects.equals(this.providedMtime, fileEntity.providedMtime) && Objects.equals(this.crc32, fileEntity.crc32) && Objects.equals(this.md5, fileEntity.md5) && Objects.equals(this.mimeType, fileEntity.mimeType) && Objects.equals(this.region, fileEntity.region) && Objects.equals(this.permissions, fileEntity.permissions) && Objects.equals(this.subfoldersLocked, fileEntity.subfoldersLocked) && Objects.equals(this.downloadUri, fileEntity.downloadUri) && Objects.equals(this.priorityColor, fileEntity.priorityColor) && Objects.equals(this.previewId, fileEntity.previewId) && Objects.equals(this.preview, fileEntity.preview);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.displayName, this.type, this.size, this.mtime, this.providedMtime, this.crc32, this.md5, this.mimeType, this.region, this.permissions, this.subfoldersLocked, this.downloadUri, this.priorityColor, this.previewId, this.preview);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FileEntity {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    mtime: ").append(this.toIndentedString(this.mtime)).append("\n");
        sb.append("    providedMtime: ").append(this.toIndentedString(this.providedMtime)).append("\n");
        sb.append("    crc32: ").append(this.toIndentedString(this.crc32)).append("\n");
        sb.append("    md5: ").append(this.toIndentedString(this.md5)).append("\n");
        sb.append("    mimeType: ").append(this.toIndentedString(this.mimeType)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    subfoldersLocked: ").append(this.toIndentedString(this.subfoldersLocked)).append("\n");
        sb.append("    downloadUri: ").append(this.toIndentedString(this.downloadUri)).append("\n");
        sb.append("    priorityColor: ").append(this.toIndentedString(this.priorityColor)).append("\n");
        sb.append("    previewId: ").append(this.toIndentedString(this.previewId)).append("\n");
        sb.append("    preview: ").append(this.toIndentedString(this.preview)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

