/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="List External Events")
public class ExternalEventEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="event_type")
    private EventTypeEnum eventType = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="body")
    private String body = null;
    @JsonProperty(value="created_at")
    private DateTime createdAt = null;
    @JsonProperty(value="body_url")
    private String bodyUrl = null;
    @JsonProperty(value="folder_behavior_id")
    private Integer folderBehaviorId = null;
    @JsonProperty(value="successful_files")
    private Integer successfulFiles = null;
    @JsonProperty(value="errored_files")
    private Integer erroredFiles = null;
    @JsonProperty(value="bytes_synced")
    private Integer bytesSynced = null;
    @JsonProperty(value="remote_server_type")
    private String remoteServerType = null;

    public ExternalEventEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="Event ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public ExternalEventEntity eventType(EventTypeEnum eventType) {
        this.eventType = eventType;
        return this;
    }

    @Schema(description="Type of event being recorded.")
    public EventTypeEnum getEventType() {
        return this.eventType;
    }

    public void setEventType(EventTypeEnum eventType) {
        this.eventType = eventType;
    }

    public ExternalEventEntity status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Schema(description="Status of event.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ExternalEventEntity body(String body) {
        this.body = body;
        return this;
    }

    @Schema(description="Event body")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public ExternalEventEntity createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(description="External event create date/time")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public ExternalEventEntity bodyUrl(String bodyUrl) {
        this.bodyUrl = bodyUrl;
        return this;
    }

    @Schema(description="Link to log file.")
    public String getBodyUrl() {
        return this.bodyUrl;
    }

    public void setBodyUrl(String bodyUrl) {
        this.bodyUrl = bodyUrl;
    }

    public ExternalEventEntity folderBehaviorId(Integer folderBehaviorId) {
        this.folderBehaviorId = folderBehaviorId;
        return this;
    }

    @Schema(example="1", description="Folder Behavior ID")
    public Integer getFolderBehaviorId() {
        return this.folderBehaviorId;
    }

    public void setFolderBehaviorId(Integer folderBehaviorId) {
        this.folderBehaviorId = folderBehaviorId;
    }

    public ExternalEventEntity successfulFiles(Integer successfulFiles) {
        this.successfulFiles = successfulFiles;
        return this;
    }

    @Schema(example="1", description="For sync events, the number of files handled successfully.")
    public Integer getSuccessfulFiles() {
        return this.successfulFiles;
    }

    public void setSuccessfulFiles(Integer successfulFiles) {
        this.successfulFiles = successfulFiles;
    }

    public ExternalEventEntity erroredFiles(Integer erroredFiles) {
        this.erroredFiles = erroredFiles;
        return this;
    }

    @Schema(example="1", description="For sync events, the number of files that encountered errors.")
    public Integer getErroredFiles() {
        return this.erroredFiles;
    }

    public void setErroredFiles(Integer erroredFiles) {
        this.erroredFiles = erroredFiles;
    }

    public ExternalEventEntity bytesSynced(Integer bytesSynced) {
        this.bytesSynced = bytesSynced;
        return this;
    }

    @Schema(example="1", description="For sync events, the total number of bytes synced.")
    public Integer getBytesSynced() {
        return this.bytesSynced;
    }

    public void setBytesSynced(Integer bytesSynced) {
        this.bytesSynced = bytesSynced;
    }

    public ExternalEventEntity remoteServerType(String remoteServerType) {
        this.remoteServerType = remoteServerType;
        return this;
    }

    @Schema(description="Associated Remote Server type, if any")
    public String getRemoteServerType() {
        return this.remoteServerType;
    }

    public void setRemoteServerType(String remoteServerType) {
        this.remoteServerType = remoteServerType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalEventEntity externalEventEntity = (ExternalEventEntity)o;
        return Objects.equals(this.id, externalEventEntity.id) && Objects.equals((Object)this.eventType, (Object)externalEventEntity.eventType) && Objects.equals((Object)this.status, (Object)externalEventEntity.status) && Objects.equals(this.body, externalEventEntity.body) && Objects.equals(this.createdAt, externalEventEntity.createdAt) && Objects.equals(this.bodyUrl, externalEventEntity.bodyUrl) && Objects.equals(this.folderBehaviorId, externalEventEntity.folderBehaviorId) && Objects.equals(this.successfulFiles, externalEventEntity.successfulFiles) && Objects.equals(this.erroredFiles, externalEventEntity.erroredFiles) && Objects.equals(this.bytesSynced, externalEventEntity.bytesSynced) && Objects.equals(this.remoteServerType, externalEventEntity.remoteServerType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.eventType, this.status, this.body, this.createdAt, this.bodyUrl, this.folderBehaviorId, this.successfulFiles, this.erroredFiles, this.bytesSynced, this.remoteServerType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalEventEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    bodyUrl: ").append(this.toIndentedString(this.bodyUrl)).append("\n");
        sb.append("    folderBehaviorId: ").append(this.toIndentedString(this.folderBehaviorId)).append("\n");
        sb.append("    successfulFiles: ").append(this.toIndentedString(this.successfulFiles)).append("\n");
        sb.append("    erroredFiles: ").append(this.toIndentedString(this.erroredFiles)).append("\n");
        sb.append("    bytesSynced: ").append(this.toIndentedString(this.bytesSynced)).append("\n");
        sb.append("    remoteServerType: ").append(this.toIndentedString(this.remoteServerType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EventTypeEnum {
        LDAP_SYNC("ldap_sync"),
        REMOTE_SERVER_SYNC("remote_server_sync"),
        LOCKOUT("lockout"),
        LDAP_LOGIN("ldap_login"),
        SAML_LOGIN("saml_login"),
        CLIENT_LOG("client_log");

        private String value;

        private EventTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EventTypeEnum fromValue(String text) {
            for (EventTypeEnum b : EventTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum StatusEnum {
        SUCCESS("success"),
        ERROR("error"),
        PARTIAL_FAILURE("partial_failure");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

