/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Show site DNS configuration.")
public class DnsRecordEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="domain")
    private String domain = null;
    @JsonProperty(value="rrtype")
    private String rrtype = null;
    @JsonProperty(value="value")
    private String value = null;

    public DnsRecordEntity id(String id) {
        this.id = id;
        return this;
    }

    @Schema(example="customdomain.com-CNAME-site.files.com", description="Unique label for DNS record; used by Zapier and other integrations.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DnsRecordEntity domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Schema(example="my-custom-domain.com", description="DNS record domain name")
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public DnsRecordEntity rrtype(String rrtype) {
        this.rrtype = rrtype;
        return this;
    }

    @Schema(example="CNAME", description="DNS record type")
    public String getRrtype() {
        return this.rrtype;
    }

    public void setRrtype(String rrtype) {
        this.rrtype = rrtype;
    }

    public DnsRecordEntity value(String value) {
        this.value = value;
        return this;
    }

    @Schema(example="mysite.files.com", description="DNS record value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DnsRecordEntity dnsRecordEntity = (DnsRecordEntity)o;
        return Objects.equals(this.id, dnsRecordEntity.id) && Objects.equals(this.domain, dnsRecordEntity.domain) && Objects.equals(this.rrtype, dnsRecordEntity.rrtype) && Objects.equals(this.value, dnsRecordEntity.value);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.domain, this.rrtype, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DnsRecordEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    rrtype: ").append(this.toIndentedString(this.rrtype)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

