/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Create Clickwrap")
public class ClickwrapEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="body")
    private String body = null;
    @JsonProperty(value="use_with_users")
    private UseWithUsersEnum useWithUsers = null;
    @JsonProperty(value="use_with_bundles")
    private UseWithBundlesEnum useWithBundles = null;
    @JsonProperty(value="use_with_inboxes")
    private UseWithInboxesEnum useWithInboxes = null;

    public ClickwrapEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="Clickwrap ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public ClickwrapEntity name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="Example Site NDA for Files.com Use", description="Name of the Clickwrap agreement (used when selecting from multiple Clickwrap agreements.)")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ClickwrapEntity body(String body) {
        this.body = body;
        return this;
    }

    @Schema(example="[Legal body text]", description="Body text of Clickwrap (supports Markdown formatting).")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public ClickwrapEntity useWithUsers(UseWithUsersEnum useWithUsers) {
        this.useWithUsers = useWithUsers;
        return this;
    }

    @Schema(description="Use this Clickwrap for User Registrations?  Note: This only applies to User Registrations where the User is invited to your Files.com site using an E-Mail invitation process where they then set their own password.")
    public UseWithUsersEnum getUseWithUsers() {
        return this.useWithUsers;
    }

    public void setUseWithUsers(UseWithUsersEnum useWithUsers) {
        this.useWithUsers = useWithUsers;
    }

    public ClickwrapEntity useWithBundles(UseWithBundlesEnum useWithBundles) {
        this.useWithBundles = useWithBundles;
        return this;
    }

    @Schema(description="Use this Clickwrap for Bundles?")
    public UseWithBundlesEnum getUseWithBundles() {
        return this.useWithBundles;
    }

    public void setUseWithBundles(UseWithBundlesEnum useWithBundles) {
        this.useWithBundles = useWithBundles;
    }

    public ClickwrapEntity useWithInboxes(UseWithInboxesEnum useWithInboxes) {
        this.useWithInboxes = useWithInboxes;
        return this;
    }

    @Schema(description="Use this Clickwrap for Inboxes?")
    public UseWithInboxesEnum getUseWithInboxes() {
        return this.useWithInboxes;
    }

    public void setUseWithInboxes(UseWithInboxesEnum useWithInboxes) {
        this.useWithInboxes = useWithInboxes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClickwrapEntity clickwrapEntity = (ClickwrapEntity)o;
        return Objects.equals(this.id, clickwrapEntity.id) && Objects.equals(this.name, clickwrapEntity.name) && Objects.equals(this.body, clickwrapEntity.body) && Objects.equals((Object)this.useWithUsers, (Object)clickwrapEntity.useWithUsers) && Objects.equals((Object)this.useWithBundles, (Object)clickwrapEntity.useWithBundles) && Objects.equals((Object)this.useWithInboxes, (Object)clickwrapEntity.useWithInboxes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.body, this.useWithUsers, this.useWithBundles, this.useWithInboxes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClickwrapEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    useWithUsers: ").append(this.toIndentedString((Object)this.useWithUsers)).append("\n");
        sb.append("    useWithBundles: ").append(this.toIndentedString((Object)this.useWithBundles)).append("\n");
        sb.append("    useWithInboxes: ").append(this.toIndentedString((Object)this.useWithInboxes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum UseWithUsersEnum {
        NONE("none"),
        REQUIRE("require");

        private String value;

        private UseWithUsersEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UseWithUsersEnum fromValue(String text) {
            for (UseWithUsersEnum b : UseWithUsersEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum UseWithBundlesEnum {
        NONE("none"),
        AVAILABLE("available"),
        REQUIRE("require");

        private String value;

        private UseWithBundlesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UseWithBundlesEnum fromValue(String text) {
            for (UseWithBundlesEnum b : UseWithBundlesEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum UseWithInboxesEnum {
        NONE("none"),
        AVAILABLE("available"),
        REQUIRE("require");

        private String value;

        private UseWithInboxesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UseWithInboxesEnum fromValue(String text) {
            for (UseWithInboxesEnum b : UseWithInboxesEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

