/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import ch.cyberduck.core.brick.io.swagger.client.model.FormFieldSetEntity;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="Create Bundle")
public class BundleEntity {
    @JsonProperty(value="code")
    private String code = null;
    @JsonProperty(value="url")
    private String url = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="password_protected")
    private Boolean passwordProtected = null;
    @JsonProperty(value="preview_only")
    private Boolean previewOnly = null;
    @JsonProperty(value="require_registration")
    private Boolean requireRegistration = null;
    @JsonProperty(value="require_share_recipient")
    private Boolean requireShareRecipient = null;
    @JsonProperty(value="clickwrap_body")
    private String clickwrapBody = null;
    @JsonProperty(value="form_field_set")
    private FormFieldSetEntity formFieldSet = null;
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="created_at")
    private DateTime createdAt = null;
    @JsonProperty(value="expires_at")
    private DateTime expiresAt = null;
    @JsonProperty(value="max_uses")
    private Integer maxUses = null;
    @JsonProperty(value="note")
    private String note = null;
    @JsonProperty(value="user_id")
    private Integer userId = null;
    @JsonProperty(value="username")
    private String username = null;
    @JsonProperty(value="clickwrap_id")
    private Integer clickwrapId = null;
    @JsonProperty(value="inbox_id")
    private Integer inboxId = null;
    @JsonProperty(value="has_inbox")
    private Boolean hasInbox = null;
    @JsonProperty(value="paths")
    private List<String> paths = null;

    public BundleEntity code(String code) {
        this.code = code;
        return this;
    }

    @Schema(example="abc123", description="Bundle code.  This code forms the end part of the Public URL.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public BundleEntity url(String url) {
        this.url = url;
        return this;
    }

    @Schema(example="https://subdomain.files.com/f/12345678", description="Public URL of Share Link")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public BundleEntity description(String description) {
        this.description = description;
        return this;
    }

    @Schema(example="The public description of the bundle.", description="Public description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BundleEntity passwordProtected(Boolean passwordProtected) {
        this.passwordProtected = passwordProtected;
        return this;
    }

    @Schema(description="Is this bundle password protected?")
    public Boolean isPasswordProtected() {
        return this.passwordProtected;
    }

    public void setPasswordProtected(Boolean passwordProtected) {
        this.passwordProtected = passwordProtected;
    }

    public BundleEntity previewOnly(Boolean previewOnly) {
        this.previewOnly = previewOnly;
        return this;
    }

    @Schema(description="Restrict users to previewing files only?")
    public Boolean isPreviewOnly() {
        return this.previewOnly;
    }

    public void setPreviewOnly(Boolean previewOnly) {
        this.previewOnly = previewOnly;
    }

    public BundleEntity requireRegistration(Boolean requireRegistration) {
        this.requireRegistration = requireRegistration;
        return this;
    }

    @Schema(description="Show a registration page that captures the downloader's name and email address?")
    public Boolean isRequireRegistration() {
        return this.requireRegistration;
    }

    public void setRequireRegistration(Boolean requireRegistration) {
        this.requireRegistration = requireRegistration;
    }

    public BundleEntity requireShareRecipient(Boolean requireShareRecipient) {
        this.requireShareRecipient = requireShareRecipient;
        return this;
    }

    @Schema(description="Only allow access to recipients who have explicitly received the share via an email sent through the Files.com UI?")
    public Boolean isRequireShareRecipient() {
        return this.requireShareRecipient;
    }

    public void setRequireShareRecipient(Boolean requireShareRecipient) {
        this.requireShareRecipient = requireShareRecipient;
    }

    public BundleEntity clickwrapBody(String clickwrapBody) {
        this.clickwrapBody = clickwrapBody;
        return this;
    }

    @Schema(example="[Legal text]", description="Legal text that must be agreed to prior to accessing Bundle.")
    public String getClickwrapBody() {
        return this.clickwrapBody;
    }

    public void setClickwrapBody(String clickwrapBody) {
        this.clickwrapBody = clickwrapBody;
    }

    public BundleEntity formFieldSet(FormFieldSetEntity formFieldSet) {
        this.formFieldSet = formFieldSet;
        return this;
    }

    @Schema(description="")
    public FormFieldSetEntity getFormFieldSet() {
        return this.formFieldSet;
    }

    public void setFormFieldSet(FormFieldSetEntity formFieldSet) {
        this.formFieldSet = formFieldSet;
    }

    public BundleEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="Bundle ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public BundleEntity createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(description="Bundle created at date/time")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public BundleEntity expiresAt(DateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Schema(description="Bundle expiration date/time")
    public DateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(DateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public BundleEntity maxUses(Integer maxUses) {
        this.maxUses = maxUses;
        return this;
    }

    @Schema(example="1", description="Maximum number of times bundle can be accessed")
    public Integer getMaxUses() {
        return this.maxUses;
    }

    public void setMaxUses(Integer maxUses) {
        this.maxUses = maxUses;
    }

    public BundleEntity note(String note) {
        this.note = note;
        return this;
    }

    @Schema(example="The internal note on the bundle.", description="Bundle internal note")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public BundleEntity userId(Integer userId) {
        this.userId = userId;
        return this;
    }

    @Schema(example="1", description="Bundle creator user ID")
    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public BundleEntity username(String username) {
        this.username = username;
        return this;
    }

    @Schema(example="user", description="Bundle creator username")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public BundleEntity clickwrapId(Integer clickwrapId) {
        this.clickwrapId = clickwrapId;
        return this;
    }

    @Schema(example="1", description="ID of the clickwrap to use with this bundle.")
    public Integer getClickwrapId() {
        return this.clickwrapId;
    }

    public void setClickwrapId(Integer clickwrapId) {
        this.clickwrapId = clickwrapId;
    }

    public BundleEntity inboxId(Integer inboxId) {
        this.inboxId = inboxId;
        return this;
    }

    @Schema(example="1", description="ID of the associated inbox, if available.")
    public Integer getInboxId() {
        return this.inboxId;
    }

    public void setInboxId(Integer inboxId) {
        this.inboxId = inboxId;
    }

    public BundleEntity hasInbox(Boolean hasInbox) {
        this.hasInbox = hasInbox;
        return this;
    }

    @Schema(example="true", description="Does this bundle have an associated inbox?")
    public Boolean isHasInbox() {
        return this.hasInbox;
    }

    public void setHasInbox(Boolean hasInbox) {
        this.hasInbox = hasInbox;
    }

    public BundleEntity paths(List<String> paths) {
        this.paths = paths;
        return this;
    }

    public BundleEntity addPathsItem(String pathsItem) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.add(pathsItem);
        return this;
    }

    @Schema(example="[\"file.txt\"]", description="A list of paths in this bundle")
    public List<String> getPaths() {
        return this.paths;
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BundleEntity bundleEntity = (BundleEntity)o;
        return Objects.equals(this.code, bundleEntity.code) && Objects.equals(this.url, bundleEntity.url) && Objects.equals(this.description, bundleEntity.description) && Objects.equals(this.passwordProtected, bundleEntity.passwordProtected) && Objects.equals(this.previewOnly, bundleEntity.previewOnly) && Objects.equals(this.requireRegistration, bundleEntity.requireRegistration) && Objects.equals(this.requireShareRecipient, bundleEntity.requireShareRecipient) && Objects.equals(this.clickwrapBody, bundleEntity.clickwrapBody) && Objects.equals(this.formFieldSet, bundleEntity.formFieldSet) && Objects.equals(this.id, bundleEntity.id) && Objects.equals(this.createdAt, bundleEntity.createdAt) && Objects.equals(this.expiresAt, bundleEntity.expiresAt) && Objects.equals(this.maxUses, bundleEntity.maxUses) && Objects.equals(this.note, bundleEntity.note) && Objects.equals(this.userId, bundleEntity.userId) && Objects.equals(this.username, bundleEntity.username) && Objects.equals(this.clickwrapId, bundleEntity.clickwrapId) && Objects.equals(this.inboxId, bundleEntity.inboxId) && Objects.equals(this.hasInbox, bundleEntity.hasInbox) && Objects.equals(this.paths, bundleEntity.paths);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.url, this.description, this.passwordProtected, this.previewOnly, this.requireRegistration, this.requireShareRecipient, this.clickwrapBody, this.formFieldSet, this.id, this.createdAt, this.expiresAt, this.maxUses, this.note, this.userId, this.username, this.clickwrapId, this.inboxId, this.hasInbox, this.paths);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BundleEntity {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    passwordProtected: ").append(this.toIndentedString(this.passwordProtected)).append("\n");
        sb.append("    previewOnly: ").append(this.toIndentedString(this.previewOnly)).append("\n");
        sb.append("    requireRegistration: ").append(this.toIndentedString(this.requireRegistration)).append("\n");
        sb.append("    requireShareRecipient: ").append(this.toIndentedString(this.requireShareRecipient)).append("\n");
        sb.append("    clickwrapBody: ").append(this.toIndentedString(this.clickwrapBody)).append("\n");
        sb.append("    formFieldSet: ").append(this.toIndentedString(this.formFieldSet)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    maxUses: ").append(this.toIndentedString(this.maxUses)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    clickwrapId: ").append(this.toIndentedString(this.clickwrapId)).append("\n");
        sb.append("    inboxId: ").append(this.toIndentedString(this.inboxId)).append("\n");
        sb.append("    hasInbox: ").append(this.toIndentedString(this.hasInbox)).append("\n");
        sb.append("    paths: ").append(this.toIndentedString(this.paths)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

