/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.File;
import java.util.Objects;

public class BehaviorsBody {
    @JsonProperty(value="value")
    private String value = null;
    @JsonProperty(value="attachment_file")
    private File attachmentFile = null;
    @JsonProperty(value="path")
    private String path = null;
    @JsonProperty(value="behavior")
    private String behavior = null;

    public BehaviorsBody value(String value) {
        this.value = value;
        return this;
    }

    @Schema(example="{\"method\": \"GET\"}", description="The value of the folder behavior.  Can be a integer, array, or hash depending on the type of folder behavior.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public BehaviorsBody attachmentFile(File attachmentFile) {
        this.attachmentFile = attachmentFile;
        return this;
    }

    @Schema(description="Certain behaviors may require a file, for instance, the \"watermark\" behavior requires a watermark image")
    public File getAttachmentFile() {
        return this.attachmentFile;
    }

    public void setAttachmentFile(File attachmentFile) {
        this.attachmentFile = attachmentFile;
    }

    public BehaviorsBody path(String path) {
        this.path = path;
        return this;
    }

    @Schema(required=true, description="Folder behaviors path.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public BehaviorsBody behavior(String behavior) {
        this.behavior = behavior;
        return this;
    }

    @Schema(example="webhook", required=true, description="Behavior type.")
    public String getBehavior() {
        return this.behavior;
    }

    public void setBehavior(String behavior) {
        this.behavior = behavior;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BehaviorsBody behaviorsBody = (BehaviorsBody)o;
        return Objects.equals(this.value, behaviorsBody.value) && Objects.equals(this.attachmentFile, behaviorsBody.attachmentFile) && Objects.equals(this.path, behaviorsBody.path) && Objects.equals(this.behavior, behaviorsBody.behavior);
    }

    public int hashCode() {
        return Objects.hash(this.value, Objects.hashCode(this.attachmentFile), this.path, this.behavior);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BehaviorsBody {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    attachmentFile: ").append(this.toIndentedString(this.attachmentFile)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    behavior: ").append(this.toIndentedString(this.behavior)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

