/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="List Behaviors")
public class BehaviorEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="path")
    private String path = null;
    @JsonProperty(value="attachment_url")
    private String attachmentUrl = null;
    @JsonProperty(value="behavior")
    private String behavior = null;
    @JsonProperty(value="value")
    private Object value = null;

    public BehaviorEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="Folder behavior ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public BehaviorEntity path(String path) {
        this.path = path;
        return this;
    }

    @Schema(description="Folder path")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public BehaviorEntity attachmentUrl(String attachmentUrl) {
        this.attachmentUrl = attachmentUrl;
        return this;
    }

    @Schema(description="URL for attached file")
    public String getAttachmentUrl() {
        return this.attachmentUrl;
    }

    public void setAttachmentUrl(String attachmentUrl) {
        this.attachmentUrl = attachmentUrl;
    }

    public BehaviorEntity behavior(String behavior) {
        this.behavior = behavior;
        return this;
    }

    @Schema(example="webhook", description="Behavior type.")
    public String getBehavior() {
        return this.behavior;
    }

    public void setBehavior(String behavior) {
        this.behavior = behavior;
    }

    public BehaviorEntity value(Object value) {
        this.value = value;
        return this;
    }

    @Schema(example="{ \"method\": \"GET\" }", description="Settings for this behavior.  See the section above for an example value to provide here.  Formatting is different for each Behavior type.  May be sent as nested JSON or a single JSON-encoded string.  If using XML encoding for the API call, this data must be sent as a JSON-encoded string.")
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BehaviorEntity behaviorEntity = (BehaviorEntity)o;
        return Objects.equals(this.id, behaviorEntity.id) && Objects.equals(this.path, behaviorEntity.path) && Objects.equals(this.attachmentUrl, behaviorEntity.attachmentUrl) && Objects.equals(this.behavior, behaviorEntity.behavior) && Objects.equals(this.value, behaviorEntity.value);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.path, this.attachmentUrl, this.behavior, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BehaviorEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    attachmentUrl: ").append(this.toIndentedString(this.attachmentUrl)).append("\n");
        sb.append("    behavior: ").append(this.toIndentedString(this.behavior)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

