/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="List Bandwidth Snapshots")
public class BandwidthSnapshotEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="bytes_received")
    private Double bytesReceived = null;
    @JsonProperty(value="bytes_sent")
    private Double bytesSent = null;
    @JsonProperty(value="sync_bytes_received")
    private Double syncBytesReceived = null;
    @JsonProperty(value="sync_bytes_sent")
    private Double syncBytesSent = null;
    @JsonProperty(value="requests_get")
    private Double requestsGet = null;
    @JsonProperty(value="requests_put")
    private Double requestsPut = null;
    @JsonProperty(value="requests_other")
    private Double requestsOther = null;
    @JsonProperty(value="logged_at")
    private DateTime loggedAt = null;
    @JsonProperty(value="created_at")
    private DateTime createdAt = null;
    @JsonProperty(value="updated_at")
    private DateTime updatedAt = null;

    public BandwidthSnapshotEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="Site bandwidth ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public BandwidthSnapshotEntity bytesReceived(Double bytesReceived) {
        this.bytesReceived = bytesReceived;
        return this;
    }

    @Schema(example="1", description="Site bandwidth report bytes received")
    public Double getBytesReceived() {
        return this.bytesReceived;
    }

    public void setBytesReceived(Double bytesReceived) {
        this.bytesReceived = bytesReceived;
    }

    public BandwidthSnapshotEntity bytesSent(Double bytesSent) {
        this.bytesSent = bytesSent;
        return this;
    }

    @Schema(example="1", description="Site bandwidth report bytes sent")
    public Double getBytesSent() {
        return this.bytesSent;
    }

    public void setBytesSent(Double bytesSent) {
        this.bytesSent = bytesSent;
    }

    public BandwidthSnapshotEntity syncBytesReceived(Double syncBytesReceived) {
        this.syncBytesReceived = syncBytesReceived;
        return this;
    }

    @Schema(example="1", description="Site sync bandwidth report bytes received")
    public Double getSyncBytesReceived() {
        return this.syncBytesReceived;
    }

    public void setSyncBytesReceived(Double syncBytesReceived) {
        this.syncBytesReceived = syncBytesReceived;
    }

    public BandwidthSnapshotEntity syncBytesSent(Double syncBytesSent) {
        this.syncBytesSent = syncBytesSent;
        return this;
    }

    @Schema(example="1", description="Site sync bandwidth report bytes sent")
    public Double getSyncBytesSent() {
        return this.syncBytesSent;
    }

    public void setSyncBytesSent(Double syncBytesSent) {
        this.syncBytesSent = syncBytesSent;
    }

    public BandwidthSnapshotEntity requestsGet(Double requestsGet) {
        this.requestsGet = requestsGet;
        return this;
    }

    @Schema(example="1", description="Site bandwidth report get requests")
    public Double getRequestsGet() {
        return this.requestsGet;
    }

    public void setRequestsGet(Double requestsGet) {
        this.requestsGet = requestsGet;
    }

    public BandwidthSnapshotEntity requestsPut(Double requestsPut) {
        this.requestsPut = requestsPut;
        return this;
    }

    @Schema(example="1", description="Site bandwidth report put requests")
    public Double getRequestsPut() {
        return this.requestsPut;
    }

    public void setRequestsPut(Double requestsPut) {
        this.requestsPut = requestsPut;
    }

    public BandwidthSnapshotEntity requestsOther(Double requestsOther) {
        this.requestsOther = requestsOther;
        return this;
    }

    @Schema(example="1", description="Site bandwidth report other requests")
    public Double getRequestsOther() {
        return this.requestsOther;
    }

    public void setRequestsOther(Double requestsOther) {
        this.requestsOther = requestsOther;
    }

    public BandwidthSnapshotEntity loggedAt(DateTime loggedAt) {
        this.loggedAt = loggedAt;
        return this;
    }

    @Schema(description="Time the site bandwidth report was logged")
    public DateTime getLoggedAt() {
        return this.loggedAt;
    }

    public void setLoggedAt(DateTime loggedAt) {
        this.loggedAt = loggedAt;
    }

    public BandwidthSnapshotEntity createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(description="Site bandwidth report created at date/time")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public BandwidthSnapshotEntity updatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Schema(description="The last time this site bandwidth report was updated")
    public DateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BandwidthSnapshotEntity bandwidthSnapshotEntity = (BandwidthSnapshotEntity)o;
        return Objects.equals(this.id, bandwidthSnapshotEntity.id) && Objects.equals(this.bytesReceived, bandwidthSnapshotEntity.bytesReceived) && Objects.equals(this.bytesSent, bandwidthSnapshotEntity.bytesSent) && Objects.equals(this.syncBytesReceived, bandwidthSnapshotEntity.syncBytesReceived) && Objects.equals(this.syncBytesSent, bandwidthSnapshotEntity.syncBytesSent) && Objects.equals(this.requestsGet, bandwidthSnapshotEntity.requestsGet) && Objects.equals(this.requestsPut, bandwidthSnapshotEntity.requestsPut) && Objects.equals(this.requestsOther, bandwidthSnapshotEntity.requestsOther) && Objects.equals(this.loggedAt, bandwidthSnapshotEntity.loggedAt) && Objects.equals(this.createdAt, bandwidthSnapshotEntity.createdAt) && Objects.equals(this.updatedAt, bandwidthSnapshotEntity.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.bytesReceived, this.bytesSent, this.syncBytesReceived, this.syncBytesSent, this.requestsGet, this.requestsPut, this.requestsOther, this.loggedAt, this.createdAt, this.updatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BandwidthSnapshotEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    bytesReceived: ").append(this.toIndentedString(this.bytesReceived)).append("\n");
        sb.append("    bytesSent: ").append(this.toIndentedString(this.bytesSent)).append("\n");
        sb.append("    syncBytesReceived: ").append(this.toIndentedString(this.syncBytesReceived)).append("\n");
        sb.append("    syncBytesSent: ").append(this.toIndentedString(this.syncBytesSent)).append("\n");
        sb.append("    requestsGet: ").append(this.toIndentedString(this.requestsGet)).append("\n");
        sb.append("    requestsPut: ").append(this.toIndentedString(this.requestsPut)).append("\n");
        sb.append("    requestsOther: ").append(this.toIndentedString(this.requestsOther)).append("\n");
        sb.append("    loggedAt: ").append(this.toIndentedString(this.loggedAt)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

