/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AutomationsBody {
    @JsonProperty(value="automation")
    private AutomationEnum automation = null;
    @JsonProperty(value="source")
    private String source = null;
    @JsonProperty(value="destination")
    private String destination = null;
    @JsonProperty(value="destinations")
    private List<String> destinations = null;
    @JsonProperty(value="destination_replace_from")
    private String destinationReplaceFrom = null;
    @JsonProperty(value="destination_replace_to")
    private String destinationReplaceTo = null;
    @JsonProperty(value="interval")
    private String interval = null;
    @JsonProperty(value="path")
    private String path = null;
    @JsonProperty(value="user_ids")
    private String userIds = null;
    @JsonProperty(value="group_ids")
    private String groupIds = null;
    @JsonProperty(value="schedule")
    private Object schedule = null;
    @JsonProperty(value="trigger")
    private TriggerEnum trigger = null;
    @JsonProperty(value="trigger_actions")
    private List<String> triggerActions = null;
    @JsonProperty(value="trigger_action_path")
    private String triggerActionPath = null;
    @JsonProperty(value="value")
    private Object value = null;

    public AutomationsBody automation(AutomationEnum automation) {
        this.automation = automation;
        return this;
    }

    @Schema(example="create_folder", required=true, description="Automation type")
    public AutomationEnum getAutomation() {
        return this.automation;
    }

    public void setAutomation(AutomationEnum automation) {
        this.automation = automation;
    }

    public AutomationsBody source(String source) {
        this.source = source;
        return this;
    }

    @Schema(example="source", description="Source Path")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public AutomationsBody destination(String destination) {
        this.destination = destination;
        return this;
    }

    @Schema(description="DEPRECATED: Destination Path. Use `destinations` instead.")
    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public AutomationsBody destinations(List<String> destinations) {
        this.destinations = destinations;
        return this;
    }

    public AutomationsBody addDestinationsItem(String destinationsItem) {
        if (this.destinations == null) {
            this.destinations = new ArrayList<String>();
        }
        this.destinations.add(destinationsItem);
        return this;
    }

    @Schema(example="[\"folder_a/file_a.txt\", {\"folder_path\":\"folder_b\", \"file_path\":\"file_b.txt\"}, {\"folder_path\":\"folder_c\"}]", description="A list of String destination paths or Hash of folder_path and optional file_path.")
    public List<String> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(List<String> destinations) {
        this.destinations = destinations;
    }

    public AutomationsBody destinationReplaceFrom(String destinationReplaceFrom) {
        this.destinationReplaceFrom = destinationReplaceFrom;
        return this;
    }

    @Schema(description="If set, this string in the destination path will be replaced with the value in `destination_replace_to`.")
    public String getDestinationReplaceFrom() {
        return this.destinationReplaceFrom;
    }

    public void setDestinationReplaceFrom(String destinationReplaceFrom) {
        this.destinationReplaceFrom = destinationReplaceFrom;
    }

    public AutomationsBody destinationReplaceTo(String destinationReplaceTo) {
        this.destinationReplaceTo = destinationReplaceTo;
        return this;
    }

    @Schema(description="If set, this string will replace the value `destination_replace_from` in the destination filename. You can use special patterns here.")
    public String getDestinationReplaceTo() {
        return this.destinationReplaceTo;
    }

    public void setDestinationReplaceTo(String destinationReplaceTo) {
        this.destinationReplaceTo = destinationReplaceTo;
    }

    public AutomationsBody interval(String interval) {
        this.interval = interval;
        return this;
    }

    @Schema(example="year", description="How often to run this automation? One of: `day`, `week`, `week_end`, `month`, `month_end`, `quarter`, `quarter_end`, `year`, `year_end`")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public AutomationsBody path(String path) {
        this.path = path;
        return this;
    }

    @Schema(description="Path on which this Automation runs.  Supports globs.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public AutomationsBody userIds(String userIds) {
        this.userIds = userIds;
        return this;
    }

    @Schema(description="A list of user IDs the automation is associated with. If sent as a string, it should be comma-delimited.")
    public String getUserIds() {
        return this.userIds;
    }

    public void setUserIds(String userIds) {
        this.userIds = userIds;
    }

    public AutomationsBody groupIds(String groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    @Schema(description="A list of group IDs the automation is associated with. If sent as a string, it should be comma-delimited.")
    public String getGroupIds() {
        return this.groupIds;
    }

    public void setGroupIds(String groupIds) {
        this.groupIds = groupIds;
    }

    public AutomationsBody schedule(Object schedule) {
        this.schedule = schedule;
        return this;
    }

    @Schema(example="{\"days_of_week\": [ 0, 1, 3 ], \"times_of_day\": [ \"7:30\", \"11:30\" ], \"time_zone\": \"Eastern Time (US & Canada)\"}", description="Custom schedule for running this automation.")
    public Object getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Object schedule) {
        this.schedule = schedule;
    }

    public AutomationsBody trigger(TriggerEnum trigger) {
        this.trigger = trigger;
        return this;
    }

    @Schema(example="realtime", description="How this automation is triggered to run. One of: `realtime`, `daily`, `custom_schedule`, `webhook`, `email`, or `action`.")
    public TriggerEnum getTrigger() {
        return this.trigger;
    }

    public void setTrigger(TriggerEnum trigger) {
        this.trigger = trigger;
    }

    public AutomationsBody triggerActions(List<String> triggerActions) {
        this.triggerActions = triggerActions;
        return this;
    }

    public AutomationsBody addTriggerActionsItem(String triggerActionsItem) {
        if (this.triggerActions == null) {
            this.triggerActions = new ArrayList<String>();
        }
        this.triggerActions.add(triggerActionsItem);
        return this;
    }

    @Schema(example="[ \"create\" ]", description="If trigger is `action`, this is the list of action types on which to trigger the automation. Valid actions are create, read, update, destroy, move, copy")
    public List<String> getTriggerActions() {
        return this.triggerActions;
    }

    public void setTriggerActions(List<String> triggerActions) {
        this.triggerActions = triggerActions;
    }

    public AutomationsBody triggerActionPath(String triggerActionPath) {
        this.triggerActionPath = triggerActionPath;
        return this;
    }

    @Schema(example="path/to/file/or/folder", description="If trigger is `action`, this is the path to watch for the specified trigger actions.")
    public String getTriggerActionPath() {
        return this.triggerActionPath;
    }

    public void setTriggerActionPath(String triggerActionPath) {
        this.triggerActionPath = triggerActionPath;
    }

    public AutomationsBody value(Object value) {
        this.value = value;
        return this;
    }

    @Schema(example="{\"limit\": \"1\"}", description="A Hash of attributes specific to the automation type.")
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutomationsBody automationsBody = (AutomationsBody)o;
        return Objects.equals((Object)this.automation, (Object)automationsBody.automation) && Objects.equals(this.source, automationsBody.source) && Objects.equals(this.destination, automationsBody.destination) && Objects.equals(this.destinations, automationsBody.destinations) && Objects.equals(this.destinationReplaceFrom, automationsBody.destinationReplaceFrom) && Objects.equals(this.destinationReplaceTo, automationsBody.destinationReplaceTo) && Objects.equals(this.interval, automationsBody.interval) && Objects.equals(this.path, automationsBody.path) && Objects.equals(this.userIds, automationsBody.userIds) && Objects.equals(this.groupIds, automationsBody.groupIds) && Objects.equals(this.schedule, automationsBody.schedule) && Objects.equals((Object)this.trigger, (Object)automationsBody.trigger) && Objects.equals(this.triggerActions, automationsBody.triggerActions) && Objects.equals(this.triggerActionPath, automationsBody.triggerActionPath) && Objects.equals(this.value, automationsBody.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.automation, this.source, this.destination, this.destinations, this.destinationReplaceFrom, this.destinationReplaceTo, this.interval, this.path, this.userIds, this.groupIds, this.schedule, this.trigger, this.triggerActions, this.triggerActionPath, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AutomationsBody {\n");
        sb.append("    automation: ").append(this.toIndentedString((Object)this.automation)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    destinations: ").append(this.toIndentedString(this.destinations)).append("\n");
        sb.append("    destinationReplaceFrom: ").append(this.toIndentedString(this.destinationReplaceFrom)).append("\n");
        sb.append("    destinationReplaceTo: ").append(this.toIndentedString(this.destinationReplaceTo)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    userIds: ").append(this.toIndentedString(this.userIds)).append("\n");
        sb.append("    groupIds: ").append(this.toIndentedString(this.groupIds)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    trigger: ").append(this.toIndentedString((Object)this.trigger)).append("\n");
        sb.append("    triggerActions: ").append(this.toIndentedString(this.triggerActions)).append("\n");
        sb.append("    triggerActionPath: ").append(this.toIndentedString(this.triggerActionPath)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AutomationEnum {
        CREATE_FOLDER("create_folder"),
        REQUEST_FILE("request_file"),
        REQUEST_MOVE("request_move"),
        COPY_NEWEST_FILE("copy_newest_file"),
        DELETE_FILE("delete_file"),
        COPY_FILE("copy_file"),
        MOVE_FILE("move_file");

        private String value;

        private AutomationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AutomationEnum fromValue(String text) {
            for (AutomationEnum b : AutomationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum TriggerEnum {
        REALTIME("realtime"),
        DAILY("daily"),
        CUSTOM_SCHEDULE("custom_schedule"),
        WEBHOOK("webhook"),
        EMAIL("email"),
        ACTION("action");

        private String value;

        private TriggerEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TriggerEnum fromValue(String text) {
            for (TriggerEnum b : TriggerEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

