/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="List Automations")
public class AutomationEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="automation")
    private AutomationEnum automation = null;
    @JsonProperty(value="trigger")
    private TriggerEnum trigger = null;
    @JsonProperty(value="interval")
    private String interval = null;
    @JsonProperty(value="next_process_on")
    private String nextProcessOn = null;
    @JsonProperty(value="schedule")
    private Object schedule = null;
    @JsonProperty(value="source")
    private String source = null;
    @JsonProperty(value="destinations")
    private String destinations = null;
    @JsonProperty(value="destination_replace_from")
    private String destinationReplaceFrom = null;
    @JsonProperty(value="destination_replace_to")
    private String destinationReplaceTo = null;
    @JsonProperty(value="path")
    private String path = null;
    @JsonProperty(value="user_id")
    private Integer userId = null;
    @JsonProperty(value="user_ids")
    private List<Integer> userIds = null;
    @JsonProperty(value="group_ids")
    private List<Integer> groupIds = null;
    @JsonProperty(value="webhook_url")
    private String webhookUrl = null;
    @JsonProperty(value="trigger_actions")
    private String triggerActions = null;
    @JsonProperty(value="trigger_action_path")
    private String triggerActionPath = null;
    @JsonProperty(value="value")
    private Object value = null;

    public AutomationEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="Automation ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public AutomationEntity automation(AutomationEnum automation) {
        this.automation = automation;
        return this;
    }

    @Schema(example="create_folder", description="Automation type")
    public AutomationEnum getAutomation() {
        return this.automation;
    }

    public void setAutomation(AutomationEnum automation) {
        this.automation = automation;
    }

    public AutomationEntity trigger(TriggerEnum trigger) {
        this.trigger = trigger;
        return this;
    }

    @Schema(example="realtime", description="How this automation is triggered to run. One of: `realtime`, `daily`, `custom_schedule`, `webhook`, `email`, or `action`.")
    public TriggerEnum getTrigger() {
        return this.trigger;
    }

    public void setTrigger(TriggerEnum trigger) {
        this.trigger = trigger;
    }

    public AutomationEntity interval(String interval) {
        this.interval = interval;
        return this;
    }

    @Schema(example="week", description="If trigger is `daily`, this specifies how often to run this automation.  One of: `day`, `week`, `week_end`, `month`, `month_end`, `quarter`, `quarter_end`, `year`, `year_end`")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public AutomationEntity nextProcessOn(String nextProcessOn) {
        this.nextProcessOn = nextProcessOn;
        return this;
    }

    @Schema(example="{}", description="If trigger is `daily`, date this automation will next run.")
    public String getNextProcessOn() {
        return this.nextProcessOn;
    }

    public void setNextProcessOn(String nextProcessOn) {
        this.nextProcessOn = nextProcessOn;
    }

    public AutomationEntity schedule(Object schedule) {
        this.schedule = schedule;
        return this;
    }

    @Schema(example="{\"days_of_week\":[0,2,4],\"times_of_day\":[390,870],\"time_zone\":\"Eastern Time (US & Canada)\"}", description="If trigger is `custom_schedule`, Custom schedule description for when the automation should be run.")
    public Object getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Object schedule) {
        this.schedule = schedule;
    }

    public AutomationEntity source(String source) {
        this.source = source;
        return this;
    }

    @Schema(description="Source Path")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public AutomationEntity destinations(String destinations) {
        this.destinations = destinations;
        return this;
    }

    @Schema(description="Destination Path")
    public String getDestinations() {
        return this.destinations;
    }

    public void setDestinations(String destinations) {
        this.destinations = destinations;
    }

    public AutomationEntity destinationReplaceFrom(String destinationReplaceFrom) {
        this.destinationReplaceFrom = destinationReplaceFrom;
        return this;
    }

    @Schema(description="If set, this string in the destination path will be replaced with the value in `destination_replace_to`.")
    public String getDestinationReplaceFrom() {
        return this.destinationReplaceFrom;
    }

    public void setDestinationReplaceFrom(String destinationReplaceFrom) {
        this.destinationReplaceFrom = destinationReplaceFrom;
    }

    public AutomationEntity destinationReplaceTo(String destinationReplaceTo) {
        this.destinationReplaceTo = destinationReplaceTo;
        return this;
    }

    @Schema(description="If set, this string will replace the value `destination_replace_from` in the destination filename. You can use special patterns here.")
    public String getDestinationReplaceTo() {
        return this.destinationReplaceTo;
    }

    public void setDestinationReplaceTo(String destinationReplaceTo) {
        this.destinationReplaceTo = destinationReplaceTo;
    }

    public AutomationEntity path(String path) {
        this.path = path;
        return this;
    }

    @Schema(description="Path on which this Automation runs.  Supports globs.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public AutomationEntity userId(Integer userId) {
        this.userId = userId;
        return this;
    }

    @Schema(example="1", description="User ID of the Automation's creator.")
    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public AutomationEntity userIds(List<Integer> userIds) {
        this.userIds = userIds;
        return this;
    }

    public AutomationEntity addUserIdsItem(Integer userIdsItem) {
        if (this.userIds == null) {
            this.userIds = new ArrayList<Integer>();
        }
        this.userIds.add(userIdsItem);
        return this;
    }

    @Schema(example="[1,2]", description="IDs of Users for the Automation (i.e. who to Request File from)")
    public List<Integer> getUserIds() {
        return this.userIds;
    }

    public void setUserIds(List<Integer> userIds) {
        this.userIds = userIds;
    }

    public AutomationEntity groupIds(List<Integer> groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    public AutomationEntity addGroupIdsItem(Integer groupIdsItem) {
        if (this.groupIds == null) {
            this.groupIds = new ArrayList<Integer>();
        }
        this.groupIds.add(groupIdsItem);
        return this;
    }

    @Schema(example="[1,2]", description="IDs of Groups for the Automation (i.e. who to Request File from)")
    public List<Integer> getGroupIds() {
        return this.groupIds;
    }

    public void setGroupIds(List<Integer> groupIds) {
        this.groupIds = groupIds;
    }

    public AutomationEntity webhookUrl(String webhookUrl) {
        this.webhookUrl = webhookUrl;
        return this;
    }

    @Schema(example="https://app.files.com/api/webhooks/abc123", description="If trigger is `webhook`, this is the URL of the webhook to trigger the Automation.")
    public String getWebhookUrl() {
        return this.webhookUrl;
    }

    public void setWebhookUrl(String webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    public AutomationEntity triggerActions(String triggerActions) {
        this.triggerActions = triggerActions;
        return this;
    }

    @Schema(example="[ \"create\" ]", description="If trigger is `action`, this is the list of action types on which to trigger the automation. Valid actions are create, read, update, destroy, move, copy")
    public String getTriggerActions() {
        return this.triggerActions;
    }

    public void setTriggerActions(String triggerActions) {
        this.triggerActions = triggerActions;
    }

    public AutomationEntity triggerActionPath(String triggerActionPath) {
        this.triggerActionPath = triggerActionPath;
        return this;
    }

    @Schema(example="path/to/file/or/folder", description="If trigger is `action`, this is the path to watch for the specified trigger actions.")
    public String getTriggerActionPath() {
        return this.triggerActionPath;
    }

    public void setTriggerActionPath(String triggerActionPath) {
        this.triggerActionPath = triggerActionPath;
    }

    public AutomationEntity value(Object value) {
        this.value = value;
        return this;
    }

    @Schema(example="{\"limit\": \"1\"}", description="A Hash of attributes specific to the automation type.")
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutomationEntity automationEntity = (AutomationEntity)o;
        return Objects.equals(this.id, automationEntity.id) && Objects.equals((Object)this.automation, (Object)automationEntity.automation) && Objects.equals((Object)this.trigger, (Object)automationEntity.trigger) && Objects.equals(this.interval, automationEntity.interval) && Objects.equals(this.nextProcessOn, automationEntity.nextProcessOn) && Objects.equals(this.schedule, automationEntity.schedule) && Objects.equals(this.source, automationEntity.source) && Objects.equals(this.destinations, automationEntity.destinations) && Objects.equals(this.destinationReplaceFrom, automationEntity.destinationReplaceFrom) && Objects.equals(this.destinationReplaceTo, automationEntity.destinationReplaceTo) && Objects.equals(this.path, automationEntity.path) && Objects.equals(this.userId, automationEntity.userId) && Objects.equals(this.userIds, automationEntity.userIds) && Objects.equals(this.groupIds, automationEntity.groupIds) && Objects.equals(this.webhookUrl, automationEntity.webhookUrl) && Objects.equals(this.triggerActions, automationEntity.triggerActions) && Objects.equals(this.triggerActionPath, automationEntity.triggerActionPath) && Objects.equals(this.value, automationEntity.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.automation, this.trigger, this.interval, this.nextProcessOn, this.schedule, this.source, this.destinations, this.destinationReplaceFrom, this.destinationReplaceTo, this.path, this.userId, this.userIds, this.groupIds, this.webhookUrl, this.triggerActions, this.triggerActionPath, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AutomationEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    automation: ").append(this.toIndentedString((Object)this.automation)).append("\n");
        sb.append("    trigger: ").append(this.toIndentedString((Object)this.trigger)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    nextProcessOn: ").append(this.toIndentedString(this.nextProcessOn)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    destinations: ").append(this.toIndentedString(this.destinations)).append("\n");
        sb.append("    destinationReplaceFrom: ").append(this.toIndentedString(this.destinationReplaceFrom)).append("\n");
        sb.append("    destinationReplaceTo: ").append(this.toIndentedString(this.destinationReplaceTo)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    userIds: ").append(this.toIndentedString(this.userIds)).append("\n");
        sb.append("    groupIds: ").append(this.toIndentedString(this.groupIds)).append("\n");
        sb.append("    webhookUrl: ").append(this.toIndentedString(this.webhookUrl)).append("\n");
        sb.append("    triggerActions: ").append(this.toIndentedString(this.triggerActions)).append("\n");
        sb.append("    triggerActionPath: ").append(this.toIndentedString(this.triggerActionPath)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AutomationEnum {
        CREATE_FOLDER("create_folder"),
        REQUEST_FILE("request_file"),
        REQUEST_MOVE("request_move"),
        COPY_NEWEST_FILE("copy_newest_file"),
        DELETE_FILE("delete_file"),
        COPY_FILE("copy_file"),
        MOVE_FILE("move_file");

        private String value;

        private AutomationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AutomationEnum fromValue(String text) {
            for (AutomationEnum b : AutomationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum TriggerEnum {
        REALTIME("realtime"),
        DAILY("daily"),
        CUSTOM_SCHEDULE("custom_schedule"),
        WEBHOOK("webhook"),
        EMAIL("email"),
        ACTION("action");

        private String value;

        private TriggerEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TriggerEnum fromValue(String text) {
            for (TriggerEnum b : TriggerEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

