/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="List Apps")
public class AppEntity {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="extended_description")
    private String extendedDescription = null;
    @JsonProperty(value="short_description")
    private String shortDescription = null;
    @JsonProperty(value="documentation_links")
    private String documentationLinks = null;
    @JsonProperty(value="icon_url")
    private String iconUrl = null;
    @JsonProperty(value="logo_url")
    private String logoUrl = null;
    @JsonProperty(value="screenshot_list_urls")
    private String screenshotListUrls = null;
    @JsonProperty(value="logo_thumbnail_url")
    private String logoThumbnailUrl = null;
    @JsonProperty(value="sso_strategy_type")
    private SsoStrategyTypeEnum ssoStrategyType = null;
    @JsonProperty(value="remote_server_type")
    private RemoteServerTypeEnum remoteServerType = null;
    @JsonProperty(value="folder_behavior_type")
    private FolderBehaviorTypeEnum folderBehaviorType = null;
    @JsonProperty(value="external_homepage_url")
    private String externalHomepageUrl = null;
    @JsonProperty(value="marketing_youtube_url")
    private String marketingYoutubeUrl = null;
    @JsonProperty(value="tutorial_youtube_url")
    private String tutorialYoutubeUrl = null;
    @JsonProperty(value="app_type")
    private AppTypeEnum appType = null;
    @JsonProperty(value="featured")
    private Boolean featured = null;

    public AppEntity name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the App")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AppEntity extendedDescription(String extendedDescription) {
        this.extendedDescription = extendedDescription;
        return this;
    }

    @Schema(description="Long form description of the App")
    public String getExtendedDescription() {
        return this.extendedDescription;
    }

    public void setExtendedDescription(String extendedDescription) {
        this.extendedDescription = extendedDescription;
    }

    public AppEntity shortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
        return this;
    }

    @Schema(description="Short description of the App")
    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public AppEntity documentationLinks(String documentationLinks) {
        this.documentationLinks = documentationLinks;
        return this;
    }

    @Schema(example="Important Info => http://files.test/learn-more", description="Collection of named links to documentation")
    public String getDocumentationLinks() {
        return this.documentationLinks;
    }

    public void setDocumentationLinks(String documentationLinks) {
        this.documentationLinks = documentationLinks;
    }

    public AppEntity iconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    @Schema(description="App icon")
    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public AppEntity logoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
        return this;
    }

    @Schema(description="Full size logo for the App")
    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public AppEntity screenshotListUrls(String screenshotListUrls) {
        this.screenshotListUrls = screenshotListUrls;
        return this;
    }

    @Schema(description="Screenshots of the App")
    public String getScreenshotListUrls() {
        return this.screenshotListUrls;
    }

    public void setScreenshotListUrls(String screenshotListUrls) {
        this.screenshotListUrls = screenshotListUrls;
    }

    public AppEntity logoThumbnailUrl(String logoThumbnailUrl) {
        this.logoThumbnailUrl = logoThumbnailUrl;
        return this;
    }

    @Schema(description="Logo thumbnail for the App")
    public String getLogoThumbnailUrl() {
        return this.logoThumbnailUrl;
    }

    public void setLogoThumbnailUrl(String logoThumbnailUrl) {
        this.logoThumbnailUrl = logoThumbnailUrl;
    }

    public AppEntity ssoStrategyType(SsoStrategyTypeEnum ssoStrategyType) {
        this.ssoStrategyType = ssoStrategyType;
        return this;
    }

    @Schema(description="Associated SSO Strategy type, if any")
    public SsoStrategyTypeEnum getSsoStrategyType() {
        return this.ssoStrategyType;
    }

    public void setSsoStrategyType(SsoStrategyTypeEnum ssoStrategyType) {
        this.ssoStrategyType = ssoStrategyType;
    }

    public AppEntity remoteServerType(RemoteServerTypeEnum remoteServerType) {
        this.remoteServerType = remoteServerType;
        return this;
    }

    @Schema(description="Associated Remote Server type, if any")
    public RemoteServerTypeEnum getRemoteServerType() {
        return this.remoteServerType;
    }

    public void setRemoteServerType(RemoteServerTypeEnum remoteServerType) {
        this.remoteServerType = remoteServerType;
    }

    public AppEntity folderBehaviorType(FolderBehaviorTypeEnum folderBehaviorType) {
        this.folderBehaviorType = folderBehaviorType;
        return this;
    }

    @Schema(description="Associated Folder Behavior type, if any")
    public FolderBehaviorTypeEnum getFolderBehaviorType() {
        return this.folderBehaviorType;
    }

    public void setFolderBehaviorType(FolderBehaviorTypeEnum folderBehaviorType) {
        this.folderBehaviorType = folderBehaviorType;
    }

    public AppEntity externalHomepageUrl(String externalHomepageUrl) {
        this.externalHomepageUrl = externalHomepageUrl;
        return this;
    }

    @Schema(description="Link to external homepage")
    public String getExternalHomepageUrl() {
        return this.externalHomepageUrl;
    }

    public void setExternalHomepageUrl(String externalHomepageUrl) {
        this.externalHomepageUrl = externalHomepageUrl;
    }

    public AppEntity marketingYoutubeUrl(String marketingYoutubeUrl) {
        this.marketingYoutubeUrl = marketingYoutubeUrl;
        return this;
    }

    @Schema(description="Marketing video page")
    public String getMarketingYoutubeUrl() {
        return this.marketingYoutubeUrl;
    }

    public void setMarketingYoutubeUrl(String marketingYoutubeUrl) {
        this.marketingYoutubeUrl = marketingYoutubeUrl;
    }

    public AppEntity tutorialYoutubeUrl(String tutorialYoutubeUrl) {
        this.tutorialYoutubeUrl = tutorialYoutubeUrl;
        return this;
    }

    @Schema(description="Tutorial video page")
    public String getTutorialYoutubeUrl() {
        return this.tutorialYoutubeUrl;
    }

    public void setTutorialYoutubeUrl(String tutorialYoutubeUrl) {
        this.tutorialYoutubeUrl = tutorialYoutubeUrl;
    }

    public AppEntity appType(AppTypeEnum appType) {
        this.appType = appType;
        return this;
    }

    @Schema(description="The type of the App")
    public AppTypeEnum getAppType() {
        return this.appType;
    }

    public void setAppType(AppTypeEnum appType) {
        this.appType = appType;
    }

    public AppEntity featured(Boolean featured) {
        this.featured = featured;
        return this;
    }

    @Schema(example="true", description="Is featured on the App listing?")
    public Boolean isFeatured() {
        return this.featured;
    }

    public void setFeatured(Boolean featured) {
        this.featured = featured;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppEntity appEntity = (AppEntity)o;
        return Objects.equals(this.name, appEntity.name) && Objects.equals(this.extendedDescription, appEntity.extendedDescription) && Objects.equals(this.shortDescription, appEntity.shortDescription) && Objects.equals(this.documentationLinks, appEntity.documentationLinks) && Objects.equals(this.iconUrl, appEntity.iconUrl) && Objects.equals(this.logoUrl, appEntity.logoUrl) && Objects.equals(this.screenshotListUrls, appEntity.screenshotListUrls) && Objects.equals(this.logoThumbnailUrl, appEntity.logoThumbnailUrl) && Objects.equals((Object)this.ssoStrategyType, (Object)appEntity.ssoStrategyType) && Objects.equals((Object)this.remoteServerType, (Object)appEntity.remoteServerType) && Objects.equals((Object)this.folderBehaviorType, (Object)appEntity.folderBehaviorType) && Objects.equals(this.externalHomepageUrl, appEntity.externalHomepageUrl) && Objects.equals(this.marketingYoutubeUrl, appEntity.marketingYoutubeUrl) && Objects.equals(this.tutorialYoutubeUrl, appEntity.tutorialYoutubeUrl) && Objects.equals((Object)this.appType, (Object)appEntity.appType) && Objects.equals(this.featured, appEntity.featured);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.extendedDescription, this.shortDescription, this.documentationLinks, this.iconUrl, this.logoUrl, this.screenshotListUrls, this.logoThumbnailUrl, this.ssoStrategyType, this.remoteServerType, this.folderBehaviorType, this.externalHomepageUrl, this.marketingYoutubeUrl, this.tutorialYoutubeUrl, this.appType, this.featured});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppEntity {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    extendedDescription: ").append(this.toIndentedString(this.extendedDescription)).append("\n");
        sb.append("    shortDescription: ").append(this.toIndentedString(this.shortDescription)).append("\n");
        sb.append("    documentationLinks: ").append(this.toIndentedString(this.documentationLinks)).append("\n");
        sb.append("    iconUrl: ").append(this.toIndentedString(this.iconUrl)).append("\n");
        sb.append("    logoUrl: ").append(this.toIndentedString(this.logoUrl)).append("\n");
        sb.append("    screenshotListUrls: ").append(this.toIndentedString(this.screenshotListUrls)).append("\n");
        sb.append("    logoThumbnailUrl: ").append(this.toIndentedString(this.logoThumbnailUrl)).append("\n");
        sb.append("    ssoStrategyType: ").append(this.toIndentedString((Object)this.ssoStrategyType)).append("\n");
        sb.append("    remoteServerType: ").append(this.toIndentedString((Object)this.remoteServerType)).append("\n");
        sb.append("    folderBehaviorType: ").append(this.toIndentedString((Object)this.folderBehaviorType)).append("\n");
        sb.append("    externalHomepageUrl: ").append(this.toIndentedString(this.externalHomepageUrl)).append("\n");
        sb.append("    marketingYoutubeUrl: ").append(this.toIndentedString(this.marketingYoutubeUrl)).append("\n");
        sb.append("    tutorialYoutubeUrl: ").append(this.toIndentedString(this.tutorialYoutubeUrl)).append("\n");
        sb.append("    appType: ").append(this.toIndentedString((Object)this.appType)).append("\n");
        sb.append("    featured: ").append(this.toIndentedString(this.featured)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SsoStrategyTypeEnum {
        GOOGLE("google"),
        AUTH0("auth0"),
        OKTA("okta"),
        ATLASSIAN("atlassian"),
        AZURE("azure"),
        BOX("box"),
        DROPBOX("dropbox"),
        SLACK("slack"),
        _UNUSED_UBUNTU("_unused_ubuntu"),
        ONELOGIN("onelogin"),
        SAML("saml"),
        IDAPTIVE("idaptive"),
        LDAP("ldap"),
        SCIM("scim");

        private String value;

        private SsoStrategyTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SsoStrategyTypeEnum fromValue(String text) {
            for (SsoStrategyTypeEnum b : SsoStrategyTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum RemoteServerTypeEnum {
        FTP("ftp"),
        SFTP("sftp"),
        S3("s3"),
        GOOGLE_CLOUD_STORAGE("google_cloud_storage"),
        WEBDAV("webdav"),
        WASABI("wasabi"),
        BACKBLAZE_B2("backblaze_b2"),
        ONE_DRIVE("one_drive"),
        RACKSPACE("rackspace"),
        BOX("box"),
        DROPBOX("dropbox"),
        GOOGLE_DRIVE("google_drive"),
        AZURE("azure"),
        SHAREPOINT("sharepoint"),
        S3_COMPATIBLE("s3_compatible");

        private String value;

        private RemoteServerTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RemoteServerTypeEnum fromValue(String text) {
            for (RemoteServerTypeEnum b : RemoteServerTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum FolderBehaviorTypeEnum {
        WEBHOOK("webhook"),
        FILE_EXPIRATION("file_expiration"),
        AUTO_ENCRYPT("auto_encrypt"),
        LOCK_SUBFOLDERS("lock_subfolders"),
        STORAGE_REGION("storage_region"),
        SERVE_PUBLICLY("serve_publicly"),
        CREATE_USER_FOLDERS("create_user_folders"),
        REMOTE_SERVER_SYNC("remote_server_sync"),
        INBOX("inbox"),
        APPEND_TIMESTAMP("append_timestamp"),
        LIMIT_FILE_EXTENSIONS("limit_file_extensions"),
        LIMIT_FILE_REGEX("limit_file_regex"),
        AMAZON_SNS("amazon_sns"),
        WATERMARK("watermark"),
        REMOTE_SERVER_MOUNT("remote_server_mount"),
        SLACK_WEBHOOK("slack_webhook");

        private String value;

        private FolderBehaviorTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FolderBehaviorTypeEnum fromValue(String text) {
            for (FolderBehaviorTypeEnum b : FolderBehaviorTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum AppTypeEnum {
        SDK("sdk"),
        SSO("sso"),
        REMOTE_SERVER("remote_server"),
        FOLDER_BEHAVIOR("folder_behavior"),
        CLIENT_APP("client_app"),
        APP_INTEGRATION("app_integration");

        private String value;

        private AppTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AppTypeEnum fromValue(String text) {
            for (AppTypeEnum b : AppTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

