/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="List Api Keys")
public class ApiKeyEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="descriptive_label")
    private String descriptiveLabel = null;
    @JsonProperty(value="created_at")
    private DateTime createdAt = null;
    @JsonProperty(value="expires_at")
    private DateTime expiresAt = null;
    @JsonProperty(value="key")
    private String key = null;
    @JsonProperty(value="last_use_at")
    private DateTime lastUseAt = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="path")
    private String path = null;
    @JsonProperty(value="permission_set")
    private PermissionSetEnum permissionSet = null;
    @JsonProperty(value="platform")
    private String platform = null;
    @JsonProperty(value="user_id")
    private Integer userId = null;

    public ApiKeyEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="API Key ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public ApiKeyEntity descriptiveLabel(String descriptiveLabel) {
        this.descriptiveLabel = descriptiveLabel;
        return this;
    }

    @Schema(example="Site-wide API key for https://site.files.com/ (key ID #1)", description="Unique label that describes this API key.  Useful for external systems where you may have API keys from multiple accounts and want a human-readable label for each key.")
    public String getDescriptiveLabel() {
        return this.descriptiveLabel;
    }

    public void setDescriptiveLabel(String descriptiveLabel) {
        this.descriptiveLabel = descriptiveLabel;
    }

    public ApiKeyEntity createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(description="Time which API Key was created")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public ApiKeyEntity expiresAt(DateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Schema(description="API Key expiration date")
    public DateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(DateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public ApiKeyEntity key(String key) {
        this.key = key;
        return this;
    }

    @Schema(example="[key]", description="API Key actual key string")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ApiKeyEntity lastUseAt(DateTime lastUseAt) {
        this.lastUseAt = lastUseAt;
        return this;
    }

    @Schema(description="API Key last used - note this value is only updated once per 3 hour period, so the 'actual' time of last use may be up to 3 hours later than this timestamp.")
    public DateTime getLastUseAt() {
        return this.lastUseAt;
    }

    public void setLastUseAt(DateTime lastUseAt) {
        this.lastUseAt = lastUseAt;
    }

    public ApiKeyEntity name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="My Main API Key", description="Internal name for the API Key.  For your use.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiKeyEntity path(String path) {
        this.path = path;
        return this;
    }

    @Schema(example="shared/docs", description="Folder path restriction for this api key.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ApiKeyEntity permissionSet(PermissionSetEnum permissionSet) {
        this.permissionSet = permissionSet;
        return this;
    }

    @Schema(example="full", description="Permissions for this API Key.  Keys with the `desktop_app` permission set only have the ability to do the functions provided in our Desktop App (File and Share Link operations).  Additional permission sets may become available in the future, such as for a Site Admin to give a key with no administrator privileges.  If you have ideas for permission sets, please let us know.")
    public PermissionSetEnum getPermissionSet() {
        return this.permissionSet;
    }

    public void setPermissionSet(PermissionSetEnum permissionSet) {
        this.permissionSet = permissionSet;
    }

    public ApiKeyEntity platform(String platform) {
        this.platform = platform;
        return this;
    }

    @Schema(example="win32", description="If this API key represents a Desktop app, what platform was it created on?")
    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public ApiKeyEntity userId(Integer userId) {
        this.userId = userId;
        return this;
    }

    @Schema(example="1", description="User ID for the owner of this API Key.  May be blank for Site-wide API Keys.")
    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiKeyEntity apiKeyEntity = (ApiKeyEntity)o;
        return Objects.equals(this.id, apiKeyEntity.id) && Objects.equals(this.descriptiveLabel, apiKeyEntity.descriptiveLabel) && Objects.equals(this.createdAt, apiKeyEntity.createdAt) && Objects.equals(this.expiresAt, apiKeyEntity.expiresAt) && Objects.equals(this.key, apiKeyEntity.key) && Objects.equals(this.lastUseAt, apiKeyEntity.lastUseAt) && Objects.equals(this.name, apiKeyEntity.name) && Objects.equals(this.path, apiKeyEntity.path) && Objects.equals((Object)this.permissionSet, (Object)apiKeyEntity.permissionSet) && Objects.equals(this.platform, apiKeyEntity.platform) && Objects.equals(this.userId, apiKeyEntity.userId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.descriptiveLabel, this.createdAt, this.expiresAt, this.key, this.lastUseAt, this.name, this.path, this.permissionSet, this.platform, this.userId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiKeyEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    descriptiveLabel: ").append(this.toIndentedString(this.descriptiveLabel)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    lastUseAt: ").append(this.toIndentedString(this.lastUseAt)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    permissionSet: ").append(this.toIndentedString((Object)this.permissionSet)).append("\n");
        sb.append("    platform: ").append(this.toIndentedString(this.platform)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PermissionSetEnum {
        NONE("none"),
        FULL("full"),
        DESKTOP_APP("desktop_app"),
        SYNC_APP("sync_app"),
        OFFICE_INTEGRATION("office_integration");

        private String value;

        private PermissionSetEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PermissionSetEnum fromValue(String text) {
            for (PermissionSetEnum b : PermissionSetEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

