/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

public class ActionNotificationExportsBody {
    @JsonProperty(value="user_id")
    private Integer userId = null;
    @JsonProperty(value="start_at")
    private DateTime startAt = null;
    @JsonProperty(value="end_at")
    private DateTime endAt = null;
    @JsonProperty(value="query_message")
    private String queryMessage = null;
    @JsonProperty(value="query_request_method")
    private String queryRequestMethod = null;
    @JsonProperty(value="query_request_url")
    private String queryRequestUrl = null;
    @JsonProperty(value="query_status")
    private String queryStatus = null;
    @JsonProperty(value="query_success")
    private Boolean querySuccess = null;
    @JsonProperty(value="query_path")
    private String queryPath = null;
    @JsonProperty(value="query_folder")
    private String queryFolder = null;

    public ActionNotificationExportsBody userId(Integer userId) {
        this.userId = userId;
        return this;
    }

    @Schema(description="User ID.  Provide a value of `0` to operate the current session's user.")
    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public ActionNotificationExportsBody startAt(DateTime startAt) {
        this.startAt = startAt;
        return this;
    }

    @Schema(description="Start date/time of export range.")
    public DateTime getStartAt() {
        return this.startAt;
    }

    public void setStartAt(DateTime startAt) {
        this.startAt = startAt;
    }

    public ActionNotificationExportsBody endAt(DateTime endAt) {
        this.endAt = endAt;
        return this;
    }

    @Schema(description="End date/time of export range.")
    public DateTime getEndAt() {
        return this.endAt;
    }

    public void setEndAt(DateTime endAt) {
        this.endAt = endAt;
    }

    public ActionNotificationExportsBody queryMessage(String queryMessage) {
        this.queryMessage = queryMessage;
        return this;
    }

    @Schema(example="Connection Refused", description="Error message associated with the request, if any.")
    public String getQueryMessage() {
        return this.queryMessage;
    }

    public void setQueryMessage(String queryMessage) {
        this.queryMessage = queryMessage;
    }

    public ActionNotificationExportsBody queryRequestMethod(String queryRequestMethod) {
        this.queryRequestMethod = queryRequestMethod;
        return this;
    }

    @Schema(example="GET", description="The HTTP request method used by the webhook.")
    public String getQueryRequestMethod() {
        return this.queryRequestMethod;
    }

    public void setQueryRequestMethod(String queryRequestMethod) {
        this.queryRequestMethod = queryRequestMethod;
    }

    public ActionNotificationExportsBody queryRequestUrl(String queryRequestUrl) {
        this.queryRequestUrl = queryRequestUrl;
        return this;
    }

    @Schema(example="http://example.com/webhook", description="The target webhook URL.")
    public String getQueryRequestUrl() {
        return this.queryRequestUrl;
    }

    public void setQueryRequestUrl(String queryRequestUrl) {
        this.queryRequestUrl = queryRequestUrl;
    }

    public ActionNotificationExportsBody queryStatus(String queryStatus) {
        this.queryStatus = queryStatus;
        return this;
    }

    @Schema(example="200", description="The HTTP status returned from the server in response to the webhook request.")
    public String getQueryStatus() {
        return this.queryStatus;
    }

    public void setQueryStatus(String queryStatus) {
        this.queryStatus = queryStatus;
    }

    public ActionNotificationExportsBody querySuccess(Boolean querySuccess) {
        this.querySuccess = querySuccess;
        return this;
    }

    @Schema(example="true", description="true if the webhook request succeeded (i.e. returned a 200 or 204 response status). false otherwise.")
    public Boolean isQuerySuccess() {
        return this.querySuccess;
    }

    public void setQuerySuccess(Boolean querySuccess) {
        this.querySuccess = querySuccess;
    }

    public ActionNotificationExportsBody queryPath(String queryPath) {
        this.queryPath = queryPath;
        return this;
    }

    @Schema(example="MyFile.txt", description="Return notifications that were triggered by actions on this specific path.")
    public String getQueryPath() {
        return this.queryPath;
    }

    public void setQueryPath(String queryPath) {
        this.queryPath = queryPath;
    }

    public ActionNotificationExportsBody queryFolder(String queryFolder) {
        this.queryFolder = queryFolder;
        return this;
    }

    @Schema(example="MyFolder", description="Return notifications that were triggered by actions in this folder.")
    public String getQueryFolder() {
        return this.queryFolder;
    }

    public void setQueryFolder(String queryFolder) {
        this.queryFolder = queryFolder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionNotificationExportsBody actionNotificationExportsBody = (ActionNotificationExportsBody)o;
        return Objects.equals(this.userId, actionNotificationExportsBody.userId) && Objects.equals(this.startAt, actionNotificationExportsBody.startAt) && Objects.equals(this.endAt, actionNotificationExportsBody.endAt) && Objects.equals(this.queryMessage, actionNotificationExportsBody.queryMessage) && Objects.equals(this.queryRequestMethod, actionNotificationExportsBody.queryRequestMethod) && Objects.equals(this.queryRequestUrl, actionNotificationExportsBody.queryRequestUrl) && Objects.equals(this.queryStatus, actionNotificationExportsBody.queryStatus) && Objects.equals(this.querySuccess, actionNotificationExportsBody.querySuccess) && Objects.equals(this.queryPath, actionNotificationExportsBody.queryPath) && Objects.equals(this.queryFolder, actionNotificationExportsBody.queryFolder);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.startAt, this.endAt, this.queryMessage, this.queryRequestMethod, this.queryRequestUrl, this.queryStatus, this.querySuccess, this.queryPath, this.queryFolder);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActionNotificationExportsBody {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    startAt: ").append(this.toIndentedString(this.startAt)).append("\n");
        sb.append("    endAt: ").append(this.toIndentedString(this.endAt)).append("\n");
        sb.append("    queryMessage: ").append(this.toIndentedString(this.queryMessage)).append("\n");
        sb.append("    queryRequestMethod: ").append(this.toIndentedString(this.queryRequestMethod)).append("\n");
        sb.append("    queryRequestUrl: ").append(this.toIndentedString(this.queryRequestUrl)).append("\n");
        sb.append("    queryStatus: ").append(this.toIndentedString(this.queryStatus)).append("\n");
        sb.append("    querySuccess: ").append(this.toIndentedString(this.querySuccess)).append("\n");
        sb.append("    queryPath: ").append(this.toIndentedString(this.queryPath)).append("\n");
        sb.append("    queryFolder: ").append(this.toIndentedString(this.queryFolder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

