/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="Show Action Notification Export")
public class ActionNotificationExportEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="export_version")
    private String exportVersion = null;
    @JsonProperty(value="start_at")
    private DateTime startAt = null;
    @JsonProperty(value="end_at")
    private DateTime endAt = null;
    @JsonProperty(value="status")
    private String status = null;
    @JsonProperty(value="query_path")
    private String queryPath = null;
    @JsonProperty(value="query_folder")
    private String queryFolder = null;
    @JsonProperty(value="query_message")
    private String queryMessage = null;
    @JsonProperty(value="query_request_method")
    private String queryRequestMethod = null;
    @JsonProperty(value="query_request_url")
    private String queryRequestUrl = null;
    @JsonProperty(value="query_status")
    private String queryStatus = null;
    @JsonProperty(value="query_success")
    private Boolean querySuccess = null;
    @JsonProperty(value="results_url")
    private String resultsUrl = null;

    public ActionNotificationExportEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="History Export ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public ActionNotificationExportEntity exportVersion(String exportVersion) {
        this.exportVersion = exportVersion;
        return this;
    }

    @Schema(example="20201213.2", description="Version of the underlying records for the export.")
    public String getExportVersion() {
        return this.exportVersion;
    }

    public void setExportVersion(String exportVersion) {
        this.exportVersion = exportVersion;
    }

    public ActionNotificationExportEntity startAt(DateTime startAt) {
        this.startAt = startAt;
        return this;
    }

    @Schema(description="Start date/time of export range.")
    public DateTime getStartAt() {
        return this.startAt;
    }

    public void setStartAt(DateTime startAt) {
        this.startAt = startAt;
    }

    public ActionNotificationExportEntity endAt(DateTime endAt) {
        this.endAt = endAt;
        return this;
    }

    @Schema(description="End date/time of export range.")
    public DateTime getEndAt() {
        return this.endAt;
    }

    public void setEndAt(DateTime endAt) {
        this.endAt = endAt;
    }

    public ActionNotificationExportEntity status(String status) {
        this.status = status;
        return this;
    }

    @Schema(example="ready", description="Status of export.  Valid values: `building`, `ready`, or `failed`")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public ActionNotificationExportEntity queryPath(String queryPath) {
        this.queryPath = queryPath;
        return this;
    }

    @Schema(example="MyFile.txt", description="Return notifications that were triggered by actions on this specific path.")
    public String getQueryPath() {
        return this.queryPath;
    }

    public void setQueryPath(String queryPath) {
        this.queryPath = queryPath;
    }

    public ActionNotificationExportEntity queryFolder(String queryFolder) {
        this.queryFolder = queryFolder;
        return this;
    }

    @Schema(example="MyFolder", description="Return notifications that were triggered by actions in this folder.")
    public String getQueryFolder() {
        return this.queryFolder;
    }

    public void setQueryFolder(String queryFolder) {
        this.queryFolder = queryFolder;
    }

    public ActionNotificationExportEntity queryMessage(String queryMessage) {
        this.queryMessage = queryMessage;
        return this;
    }

    @Schema(example="Connection Refused", description="Error message associated with the request, if any.")
    public String getQueryMessage() {
        return this.queryMessage;
    }

    public void setQueryMessage(String queryMessage) {
        this.queryMessage = queryMessage;
    }

    public ActionNotificationExportEntity queryRequestMethod(String queryRequestMethod) {
        this.queryRequestMethod = queryRequestMethod;
        return this;
    }

    @Schema(example="GET", description="The HTTP request method used by the webhook.")
    public String getQueryRequestMethod() {
        return this.queryRequestMethod;
    }

    public void setQueryRequestMethod(String queryRequestMethod) {
        this.queryRequestMethod = queryRequestMethod;
    }

    public ActionNotificationExportEntity queryRequestUrl(String queryRequestUrl) {
        this.queryRequestUrl = queryRequestUrl;
        return this;
    }

    @Schema(example="http://example.com/webhook", description="The target webhook URL.")
    public String getQueryRequestUrl() {
        return this.queryRequestUrl;
    }

    public void setQueryRequestUrl(String queryRequestUrl) {
        this.queryRequestUrl = queryRequestUrl;
    }

    public ActionNotificationExportEntity queryStatus(String queryStatus) {
        this.queryStatus = queryStatus;
        return this;
    }

    @Schema(example="200", description="The HTTP status returned from the server in response to the webhook request.")
    public String getQueryStatus() {
        return this.queryStatus;
    }

    public void setQueryStatus(String queryStatus) {
        this.queryStatus = queryStatus;
    }

    public ActionNotificationExportEntity querySuccess(Boolean querySuccess) {
        this.querySuccess = querySuccess;
        return this;
    }

    @Schema(example="true", description="true if the webhook request succeeded (i.e. returned a 200 or 204 response status). false otherwise.")
    public Boolean isQuerySuccess() {
        return this.querySuccess;
    }

    public void setQuerySuccess(Boolean querySuccess) {
        this.querySuccess = querySuccess;
    }

    public ActionNotificationExportEntity resultsUrl(String resultsUrl) {
        this.resultsUrl = resultsUrl;
        return this;
    }

    @Schema(example="https://files.com/action_notification_results.csv", description="If `status` is `ready`, this will be a URL where all the results can be downloaded at once as a CSV.")
    public String getResultsUrl() {
        return this.resultsUrl;
    }

    public void setResultsUrl(String resultsUrl) {
        this.resultsUrl = resultsUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionNotificationExportEntity actionNotificationExportEntity = (ActionNotificationExportEntity)o;
        return Objects.equals(this.id, actionNotificationExportEntity.id) && Objects.equals(this.exportVersion, actionNotificationExportEntity.exportVersion) && Objects.equals(this.startAt, actionNotificationExportEntity.startAt) && Objects.equals(this.endAt, actionNotificationExportEntity.endAt) && Objects.equals(this.status, actionNotificationExportEntity.status) && Objects.equals(this.queryPath, actionNotificationExportEntity.queryPath) && Objects.equals(this.queryFolder, actionNotificationExportEntity.queryFolder) && Objects.equals(this.queryMessage, actionNotificationExportEntity.queryMessage) && Objects.equals(this.queryRequestMethod, actionNotificationExportEntity.queryRequestMethod) && Objects.equals(this.queryRequestUrl, actionNotificationExportEntity.queryRequestUrl) && Objects.equals(this.queryStatus, actionNotificationExportEntity.queryStatus) && Objects.equals(this.querySuccess, actionNotificationExportEntity.querySuccess) && Objects.equals(this.resultsUrl, actionNotificationExportEntity.resultsUrl);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.exportVersion, this.startAt, this.endAt, this.status, this.queryPath, this.queryFolder, this.queryMessage, this.queryRequestMethod, this.queryRequestUrl, this.queryStatus, this.querySuccess, this.resultsUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActionNotificationExportEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    exportVersion: ").append(this.toIndentedString(this.exportVersion)).append("\n");
        sb.append("    startAt: ").append(this.toIndentedString(this.startAt)).append("\n");
        sb.append("    endAt: ").append(this.toIndentedString(this.endAt)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    queryPath: ").append(this.toIndentedString(this.queryPath)).append("\n");
        sb.append("    queryFolder: ").append(this.toIndentedString(this.queryFolder)).append("\n");
        sb.append("    queryMessage: ").append(this.toIndentedString(this.queryMessage)).append("\n");
        sb.append("    queryRequestMethod: ").append(this.toIndentedString(this.queryRequestMethod)).append("\n");
        sb.append("    queryRequestUrl: ").append(this.toIndentedString(this.queryRequestUrl)).append("\n");
        sb.append("    queryStatus: ").append(this.toIndentedString(this.queryStatus)).append("\n");
        sb.append("    querySuccess: ").append(this.toIndentedString(this.querySuccess)).append("\n");
        sb.append("    resultsUrl: ").append(this.toIndentedString(this.resultsUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

