/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="List site full action history.")
public class ActionEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="path")
    private String path = null;
    @JsonProperty(value="when")
    private DateTime when = null;
    @JsonProperty(value="destination")
    private String destination = null;
    @JsonProperty(value="display")
    private String display = null;
    @JsonProperty(value="ip")
    private String ip = null;
    @JsonProperty(value="source")
    private String source = null;
    @JsonProperty(value="targets")
    private List<String> targets = null;
    @JsonProperty(value="user_id")
    private Integer userId = null;
    @JsonProperty(value="username")
    private String username = null;
    @JsonProperty(value="action")
    private ActionEnum action = null;
    @JsonProperty(value="failure_type")
    private FailureTypeEnum failureType = null;
    @JsonProperty(value="interface")
    private InterfaceEnum _interface = null;

    public ActionEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="Action ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public ActionEntity path(String path) {
        this.path = path;
        return this;
    }

    @Schema(example="path", description="Path")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ActionEntity when(DateTime when) {
        this.when = when;
        return this;
    }

    @Schema(description="Action occurrence date/time")
    public DateTime getWhen() {
        return this.when;
    }

    public void setWhen(DateTime when) {
        this.when = when;
    }

    public ActionEntity destination(String destination) {
        this.destination = destination;
        return this;
    }

    @Schema(example="/to_path", description="The destination path for this action, if applicable")
    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public ActionEntity display(String display) {
        this.display = display;
        return this;
    }

    @Schema(example="Actual text of the action here.", description="Friendly displayed output")
    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public ActionEntity ip(String ip) {
        this.ip = ip;
        return this;
    }

    @Schema(example="192.283.128.182", description="IP Address that performed this action")
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public ActionEntity source(String source) {
        this.source = source;
        return this;
    }

    @Schema(example="/from_path", description="The source path for this action, if applicable")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public ActionEntity targets(List<String> targets) {
        this.targets = targets;
        return this;
    }

    public ActionEntity addTargetsItem(String targetsItem) {
        if (this.targets == null) {
            this.targets = new ArrayList<String>();
        }
        this.targets.add(targetsItem);
        return this;
    }

    @Schema(example="[]", description="Targets")
    public List<String> getTargets() {
        return this.targets;
    }

    public void setTargets(List<String> targets) {
        this.targets = targets;
    }

    public ActionEntity userId(Integer userId) {
        this.userId = userId;
        return this;
    }

    @Schema(example="1", description="User ID")
    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public ActionEntity username(String username) {
        this.username = username;
        return this;
    }

    @Schema(example="user", description="Username")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public ActionEntity action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @Schema(example="create", description="Type of action")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public ActionEntity failureType(FailureTypeEnum failureType) {
        this.failureType = failureType;
        return this;
    }

    @Schema(example="none", description="Failure type.  If action was a user login or session failure, why did it fail?")
    public FailureTypeEnum getFailureType() {
        return this.failureType;
    }

    public void setFailureType(FailureTypeEnum failureType) {
        this.failureType = failureType;
    }

    public ActionEntity _interface(InterfaceEnum _interface) {
        this._interface = _interface;
        return this;
    }

    @Schema(example="web", description="Interface on which this action occurred.")
    public InterfaceEnum getInterface() {
        return this._interface;
    }

    public void setInterface(InterfaceEnum _interface) {
        this._interface = _interface;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionEntity actionEntity = (ActionEntity)o;
        return Objects.equals(this.id, actionEntity.id) && Objects.equals(this.path, actionEntity.path) && Objects.equals(this.when, actionEntity.when) && Objects.equals(this.destination, actionEntity.destination) && Objects.equals(this.display, actionEntity.display) && Objects.equals(this.ip, actionEntity.ip) && Objects.equals(this.source, actionEntity.source) && Objects.equals(this.targets, actionEntity.targets) && Objects.equals(this.userId, actionEntity.userId) && Objects.equals(this.username, actionEntity.username) && Objects.equals((Object)this.action, (Object)actionEntity.action) && Objects.equals((Object)this.failureType, (Object)actionEntity.failureType) && Objects.equals((Object)this._interface, (Object)actionEntity._interface);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.path, this.when, this.destination, this.display, this.ip, this.source, this.targets, this.userId, this.username, this.action, this.failureType, this._interface});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActionEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    when: ").append(this.toIndentedString(this.when)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    display: ").append(this.toIndentedString(this.display)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    targets: ").append(this.toIndentedString(this.targets)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    failureType: ").append(this.toIndentedString((Object)this.failureType)).append("\n");
        sb.append("    _interface: ").append(this.toIndentedString((Object)this._interface)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ActionEnum {
        CREATE("create"),
        READ("read"),
        UPDATE("update"),
        DESTROY("destroy"),
        MOVE("move"),
        LOGIN("login"),
        FAILEDLOGIN("failedlogin"),
        COPY("copy"),
        USER_CREATE("user_create"),
        USER_UPDATE("user_update"),
        USER_DESTROY("user_destroy"),
        GROUP_CREATE("group_create"),
        GROUP_UPDATE("group_update"),
        GROUP_DESTROY("group_destroy"),
        PERMISSION_CREATE("permission_create"),
        PERMISSION_DESTROY("permission_destroy"),
        API_KEY_CREATE("api_key_create"),
        API_KEY_UPDATE("api_key_update"),
        API_KEY_DESTROY("api_key_destroy");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ActionEnum fromValue(String text) {
            for (ActionEnum b : ActionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum FailureTypeEnum {
        EXPIRED_TRIAL("expired_trial"),
        ACCOUNT_OVERDUE("account_overdue"),
        LOCKED_OUT("locked_out"),
        IP_MISMATCH("ip_mismatch"),
        PASSWORD_MISMATCH("password_mismatch"),
        SITE_MISMATCH("site_mismatch"),
        USERNAME_NOT_FOUND("username_not_found"),
        NONE("none"),
        NO_FTP_PERMISSION("no_ftp_permission"),
        NO_WEB_PERMISSION("no_web_permission"),
        NO_DIRECTORY("no_directory"),
        ERRNO_ENOENT("errno_enoent"),
        NO_SFTP_PERMISSION("no_sftp_permission"),
        NO_DAV_PERMISSION("no_dav_permission"),
        NO_RESTAPI_PERMISSION("no_restapi_permission"),
        KEY_MISMATCH("key_mismatch"),
        REGION_MISMATCH("region_mismatch"),
        EXPIRED_ACCESS("expired_access"),
        DESKTOP_IP_MISMATCH("desktop_ip_mismatch"),
        DESKTOP_API_KEY_NOT_USED_QUICKLY_ENOUGH("desktop_api_key_not_used_quickly_enough"),
        DISABLED("disabled"),
        COUNTRY_MISMATCH("country_mismatch");

        private String value;

        private FailureTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FailureTypeEnum fromValue(String text) {
            for (FailureTypeEnum b : FailureTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum InterfaceEnum {
        WEB("web"),
        FTP("ftp"),
        ROBOT("robot"),
        JSAPI("jsapi"),
        WEBDESKTOPAPI("webdesktopapi"),
        SFTP("sftp"),
        DAV("dav"),
        DESKTOP("desktop"),
        RESTAPI("restapi"),
        SCIM("scim"),
        OFFICE("office");

        private String value;

        private InterfaceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InterfaceEnum fromValue(String text) {
            for (InterfaceEnum b : InterfaceEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

