/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.model;

import ch.cyberduck.core.brick.io.swagger.client.model.InvoiceLineItemEntity;
import ch.cyberduck.core.brick.io.swagger.client.model.PaymentLineItemEntity;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="List Payments")
public class AccountLineItemEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="amount")
    private Double amount = null;
    @JsonProperty(value="balance")
    private Double balance = null;
    @JsonProperty(value="created_at")
    private DateTime createdAt = null;
    @JsonProperty(value="currency")
    private String currency = null;
    @JsonProperty(value="download_uri")
    private String downloadUri = null;
    @JsonProperty(value="invoice_line_items")
    private InvoiceLineItemEntity invoiceLineItems = null;
    @JsonProperty(value="method")
    private String method = null;
    @JsonProperty(value="payment_line_items")
    private PaymentLineItemEntity paymentLineItems = null;
    @JsonProperty(value="payment_reversed_at")
    private DateTime paymentReversedAt = null;
    @JsonProperty(value="payment_type")
    private String paymentType = null;
    @JsonProperty(value="site_name")
    private String siteName = null;
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="updated_at")
    private DateTime updatedAt = null;

    public AccountLineItemEntity id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(example="1", description="Line item Id")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public AccountLineItemEntity amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @Schema(example="1", description="Line item amount")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public AccountLineItemEntity balance(Double balance) {
        this.balance = balance;
        return this;
    }

    @Schema(example="1", description="Line item balance")
    public Double getBalance() {
        return this.balance;
    }

    public void setBalance(Double balance) {
        this.balance = balance;
    }

    public AccountLineItemEntity createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(description="Line item created at")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public AccountLineItemEntity currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Schema(example="USD", description="Line item currency")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public AccountLineItemEntity downloadUri(String downloadUri) {
        this.downloadUri = downloadUri;
        return this;
    }

    @Schema(example="https://url...", description="Line item download uri")
    public String getDownloadUri() {
        return this.downloadUri;
    }

    public void setDownloadUri(String downloadUri) {
        this.downloadUri = downloadUri;
    }

    public AccountLineItemEntity invoiceLineItems(InvoiceLineItemEntity invoiceLineItems) {
        this.invoiceLineItems = invoiceLineItems;
        return this;
    }

    @Schema(description="")
    public InvoiceLineItemEntity getInvoiceLineItems() {
        return this.invoiceLineItems;
    }

    public void setInvoiceLineItems(InvoiceLineItemEntity invoiceLineItems) {
        this.invoiceLineItems = invoiceLineItems;
    }

    public AccountLineItemEntity method(String method) {
        this.method = method;
        return this;
    }

    @Schema(example="paypal", description="Line item payment method")
    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public AccountLineItemEntity paymentLineItems(PaymentLineItemEntity paymentLineItems) {
        this.paymentLineItems = paymentLineItems;
        return this;
    }

    @Schema(description="")
    public PaymentLineItemEntity getPaymentLineItems() {
        return this.paymentLineItems;
    }

    public void setPaymentLineItems(PaymentLineItemEntity paymentLineItems) {
        this.paymentLineItems = paymentLineItems;
    }

    public AccountLineItemEntity paymentReversedAt(DateTime paymentReversedAt) {
        this.paymentReversedAt = paymentReversedAt;
        return this;
    }

    @Schema(description="Date/time payment was reversed if applicable")
    public DateTime getPaymentReversedAt() {
        return this.paymentReversedAt;
    }

    public void setPaymentReversedAt(DateTime paymentReversedAt) {
        this.paymentReversedAt = paymentReversedAt;
    }

    public AccountLineItemEntity paymentType(String paymentType) {
        this.paymentType = paymentType;
        return this;
    }

    @Schema(description="Type of payment if applicable")
    public String getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    public AccountLineItemEntity siteName(String siteName) {
        this.siteName = siteName;
        return this;
    }

    @Schema(example="My Site", description="Site name this line item is for")
    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public AccountLineItemEntity type(String type) {
        this.type = type;
        return this;
    }

    @Schema(example="invoice", description="Type of line item, either payment or invoice")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public AccountLineItemEntity updatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Schema(description="Line item updated at")
    public DateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountLineItemEntity accountLineItemEntity = (AccountLineItemEntity)o;
        return Objects.equals(this.id, accountLineItemEntity.id) && Objects.equals(this.amount, accountLineItemEntity.amount) && Objects.equals(this.balance, accountLineItemEntity.balance) && Objects.equals(this.createdAt, accountLineItemEntity.createdAt) && Objects.equals(this.currency, accountLineItemEntity.currency) && Objects.equals(this.downloadUri, accountLineItemEntity.downloadUri) && Objects.equals(this.invoiceLineItems, accountLineItemEntity.invoiceLineItems) && Objects.equals(this.method, accountLineItemEntity.method) && Objects.equals(this.paymentLineItems, accountLineItemEntity.paymentLineItems) && Objects.equals(this.paymentReversedAt, accountLineItemEntity.paymentReversedAt) && Objects.equals(this.paymentType, accountLineItemEntity.paymentType) && Objects.equals(this.siteName, accountLineItemEntity.siteName) && Objects.equals(this.type, accountLineItemEntity.type) && Objects.equals(this.updatedAt, accountLineItemEntity.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.amount, this.balance, this.createdAt, this.currency, this.downloadUri, this.invoiceLineItems, this.method, this.paymentLineItems, this.paymentReversedAt, this.paymentType, this.siteName, this.type, this.updatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountLineItemEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    downloadUri: ").append(this.toIndentedString(this.downloadUri)).append("\n");
        sb.append("    invoiceLineItems: ").append(this.toIndentedString(this.invoiceLineItems)).append("\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    paymentLineItems: ").append(this.toIndentedString(this.paymentLineItems)).append("\n");
        sb.append("    paymentReversedAt: ").append(this.toIndentedString(this.paymentReversedAt)).append("\n");
        sb.append("    paymentType: ").append(this.toIndentedString(this.paymentType)).append("\n");
        sb.append("    siteName: ").append(this.toIndentedString(this.siteName)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

