/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick.io.swagger.client.api;

import ch.cyberduck.core.brick.io.swagger.client.ApiClient;
import ch.cyberduck.core.brick.io.swagger.client.ApiException;
import ch.cyberduck.core.brick.io.swagger.client.Configuration;
import ch.cyberduck.core.brick.io.swagger.client.Pair;
import ch.cyberduck.core.brick.io.swagger.client.model.ActionEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;
import org.joda.time.DateTime;

public class HistoryApi {
    private ApiClient apiClient;

    public HistoryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HistoryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public List<ActionEntity> list(DateTime startAt, DateTime endAt, String display, String cursor, Integer perPage, Object sortBy, Object filter, Object filterGt, Object filterGteq, Object filterLike, Object filterLt, Object filterLteq) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/history";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_at", startAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_at", endAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "display", display));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cursor", cursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "per_page", perPage));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_by", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter_gt", filterGt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter_gteq", filterGteq));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter_like", filterLike));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter_lt", filterLt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter_lteq", filterLteq));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<ActionEntity>> localVarReturnType = new GenericType<List<ActionEntity>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ActionEntity> listForFile(String path, DateTime startAt, DateTime endAt, String display, String cursor, Integer perPage, Object sortBy) throws ApiException {
        Object localVarPostBody = null;
        if (path == null) {
            throw new ApiException(400, "Missing the required parameter 'path' when calling listForFile");
        }
        String localVarPath = "/history/files/{path}".replaceAll("\\{path\\}", this.apiClient.escapeString(path.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_at", startAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_at", endAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "display", display));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cursor", cursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "per_page", perPage));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_by", sortBy));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<ActionEntity>> localVarReturnType = new GenericType<List<ActionEntity>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ActionEntity> listForFolder(String path, DateTime startAt, DateTime endAt, String display, String cursor, Integer perPage, Object sortBy) throws ApiException {
        Object localVarPostBody = null;
        if (path == null) {
            throw new ApiException(400, "Missing the required parameter 'path' when calling listForFolder");
        }
        String localVarPath = "/history/folders/{path}".replaceAll("\\{path\\}", this.apiClient.escapeString(path.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_at", startAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_at", endAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "display", display));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cursor", cursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "per_page", perPage));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_by", sortBy));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<ActionEntity>> localVarReturnType = new GenericType<List<ActionEntity>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ActionEntity> listForUser(Integer userId, DateTime startAt, DateTime endAt, String display, String cursor, Integer perPage, Object sortBy) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listForUser");
        }
        String localVarPath = "/history/users/{user_id}".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_at", startAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_at", endAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "display", display));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cursor", cursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "per_page", perPage));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_by", sortBy));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<ActionEntity>> localVarReturnType = new GenericType<List<ActionEntity>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ActionEntity> listLogins(DateTime startAt, DateTime endAt, String display, String cursor, Integer perPage, Object sortBy) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/history/login";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_at", startAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_at", endAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "display", display));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cursor", cursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "per_page", perPage));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_by", sortBy));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<ActionEntity>> localVarReturnType = new GenericType<List<ActionEntity>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

