/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.brick.BrickAttributesFinderFeature;
import ch.cyberduck.core.brick.BrickSession;
import ch.cyberduck.core.brick.BrickUploadFeature;
import ch.cyberduck.core.brick.io.swagger.client.model.FileEntity;
import ch.cyberduck.core.brick.io.swagger.client.model.FileUploadPartEntity;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.io.MD5ChecksumCompute;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.output.ProxyOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrickWriteFeature
extends AbstractHttpWriteFeature<FileEntity> {
    private static final Logger log = LogManager.getLogger(BrickWriteFeature.class);
    private final BrickSession session;

    public BrickWriteFeature(BrickSession session) {
        super((AttributesAdapter)new BrickAttributesFinderFeature(session));
        this.session = session;
    }

    public HttpResponseOutputStream<FileEntity> write(final Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        String uploadUri;
        FileUploadPartEntity uploadPartEntity = null;
        if (StringUtils.isBlank((CharSequence)status.getUrl())) {
            uploadPartEntity = new BrickUploadFeature(this.session, (Write<FileEntity>)this).startUpload(file);
            uploadUri = uploadPartEntity.getUploadUri();
        } else {
            uploadUri = status.getUrl();
        }
        final HttpResponseOutputStream stream = this.write(file, status, (DelayedHttpEntityCallable)new DelayedHttpEntityCallable<FileEntity>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public FileEntity call(AbstractHttpEntity entity) throws BackgroundException {
                try {
                    HttpPut request = new HttpPut(uploadUri);
                    request.setEntity((HttpEntity)entity);
                    request.setHeader("Content-Type", "application/octet-stream");
                    CloseableHttpResponse response = ((CloseableHttpClient)BrickWriteFeature.this.session.getClient()).execute((HttpUriRequest)request);
                    try {
                        switch (response.getStatusLine().getStatusCode()) {
                            case 200: {
                                if (response.containsHeader("ETag")) {
                                    if (log.isInfoEnabled()) {
                                        log.info(String.format("Received response %s for part number %d", response, status.getPart()));
                                    }
                                    if (HashAlgorithm.md5.equals((Object)status.getChecksum().algorithm)) {
                                        Checksum etag = Checksum.parse((String)StringUtils.remove((String)response.getFirstHeader("ETag").getValue(), (char)'\"'));
                                        if (!status.getChecksum().equals((Object)etag)) {
                                            throw new ChecksumException(MessageFormat.format(LocaleFactory.localizedString((String)"Upload {0} failed", (String)"Error"), file.getName()), MessageFormat.format("Mismatch between {0} hash {1} of uploaded data and ETag {2} returned by the server", etag.algorithm.toString(), status.getChecksum().hash, etag.hash));
                                        }
                                    }
                                } else if (log.isDebugEnabled()) {
                                    log.debug("No ETag header in response available");
                                }
                                FileEntity fileEntity = null;
                                return fileEntity;
                            }
                        }
                        EntityUtils.updateEntity((HttpResponse)response, (HttpEntity)new BufferedHttpEntity(response.getEntity()));
                        throw new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                }
                catch (HttpResponseException e) {
                    throw new DefaultHttpResponseExceptionMappingService().map(e);
                }
                catch (IOException e) {
                    throw new DefaultIOExceptionMappingService().map(e);
                }
            }

            public long getContentLength() {
                return status.getLength();
            }
        });
        if (StringUtils.isBlank((CharSequence)status.getUrl())) {
            final String ref = uploadPartEntity.getRef();
            return new HttpResponseOutputStream<FileEntity>((OutputStream)new ProxyOutputStream((OutputStream)stream), (AttributesAdapter)new BrickAttributesFinderFeature(this.session), status){
                private final AtomicBoolean close;
                {
                    super(proxy, attributes, status2);
                    this.close = new AtomicBoolean();
                }

                public FileEntity getStatus() throws BackgroundException {
                    return (FileEntity)stream.getStatus();
                }

                public void close() throws IOException {
                    if (this.close.get()) {
                        log.warn(String.format("Skip double close of stream %s", new Object[]{this}));
                        return;
                    }
                    super.close();
                    try {
                        new BrickUploadFeature(BrickWriteFeature.this.session, (Write<FileEntity>)BrickWriteFeature.this).completeUpload(file, ref, status, Collections.singletonList(status));
                    }
                    catch (BackgroundException e) {
                        throw new IOException(e.getMessage(), e);
                    }
                    finally {
                        this.close.set(true);
                    }
                }
            };
        }
        return stream;
    }

    public ChecksumCompute checksum(Path file, TransferStatus status) {
        return new MD5ChecksumCompute();
    }

    public boolean timestamp() {
        return true;
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }
}

