/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.BytecountStreamListener;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.brick.BrickApiClient;
import ch.cyberduck.core.brick.BrickAttributesFinderFeature;
import ch.cyberduck.core.brick.BrickExceptionMappingService;
import ch.cyberduck.core.brick.BrickSession;
import ch.cyberduck.core.brick.io.swagger.client.ApiException;
import ch.cyberduck.core.brick.io.swagger.client.api.FileActionsApi;
import ch.cyberduck.core.brick.io.swagger.client.api.FilesApi;
import ch.cyberduck.core.brick.io.swagger.client.model.BeginUploadPathBody;
import ch.cyberduck.core.brick.io.swagger.client.model.FileEntity;
import ch.cyberduck.core.brick.io.swagger.client.model.FileUploadPartEntity;
import ch.cyberduck.core.brick.io.swagger.client.model.FilesPathBody;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpUploadFeature;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.io.StreamProgress;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import ch.cyberduck.core.transfer.SegmentRetryCallable;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;

public class BrickUploadFeature
extends HttpUploadFeature<FileEntity, MessageDigest> {
    private static final Logger log = LogManager.getLogger(BrickUploadFeature.class);
    public static final int MAXIMUM_UPLOAD_PARTS = 10000;
    private final BrickSession session;
    private final Write<FileEntity> writer;
    private final Long partsize;
    private final Integer concurrency;

    public BrickUploadFeature(BrickSession session, Write<FileEntity> writer) {
        this(session, writer, PreferencesFactory.get().getLong("brick.upload.multipart.size"), PreferencesFactory.get().getInteger("brick.upload.multipart.concurrency"));
    }

    public BrickUploadFeature(BrickSession session, Write<FileEntity> writer, Long partsize, Integer concurrency) {
        super(writer);
        this.session = session;
        this.writer = writer;
        this.partsize = partsize;
        this.concurrency = concurrency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEntity upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        ThreadPool pool = ThreadPoolFactory.get((String)"multipart", (int)this.concurrency);
        try {
            long size = status.getLength() + status.getOffset();
            ArrayList<Future<TransferStatus>> parts = new ArrayList<Future<TransferStatus>>();
            ArrayList<TransferStatus> checksums = new ArrayList<TransferStatus>();
            long offset = 0L;
            long remaining = status.getLength();
            String ref = null;
            int partNumber = 1;
            while (remaining > 0L) {
                FileUploadPartEntity fileEntity = this.continueUpload(file, ref, partNumber);
                long length = fileEntity.isParallelParts() != false ? Math.min(Math.max(size / 9999L, this.partsize), remaining) : remaining;
                parts.add(this.submit(pool, file, local, throttle, listener, status, fileEntity.getUploadUri(), partNumber, offset, length, callback));
                remaining -= length;
                offset += length;
                ref = fileEntity.getRef();
                ++partNumber;
            }
            for (Future future : parts) {
                try {
                    checksums.add((TransferStatus)Uninterruptibles.getUninterruptibly((Future)future));
                }
                catch (ExecutionException e) {
                    log.warn(String.format("Part upload failed with execution failure %s", e.getMessage()));
                    Throwables.throwIfInstanceOf((Throwable)Throwables.getRootCause((Throwable)e), BackgroundException.class);
                    throw new DefaultExceptionMappingService().map(Throwables.getRootCause((Throwable)e));
                }
            }
            FileEntity entity = this.completeUpload(file, ref, status, checksums);
            status.withResponse(new BrickAttributesFinderFeature(this.session).toAttributes(entity)).setComplete();
            FileEntity fileEntity = entity;
            return fileEntity;
        }
        finally {
            pool.shutdown(false);
        }
    }

    protected FileUploadPartEntity startUpload(Path file) throws BackgroundException {
        return this.continueUpload(file, null, 1);
    }

    protected FileUploadPartEntity continueUpload(Path file, String ref, int partNumber) throws BackgroundException {
        List<FileUploadPartEntity> uploadPartEntities;
        try {
            uploadPartEntities = new FileActionsApi(new BrickApiClient(this.session)).beginUpload(StringUtils.removeStart((String)file.getAbsolute(), (String)String.valueOf('/')), new BeginUploadPathBody().ref(ref).part(partNumber));
        }
        catch (ApiException e) {
            throw new BrickExceptionMappingService().map("Upload {0} failed", e, file);
        }
        Optional entity = uploadPartEntities.stream().findFirst();
        if (!entity.isPresent()) {
            throw new NotfoundException(file.getAbsolute());
        }
        return (FileUploadPartEntity)entity.get();
    }

    protected FileEntity completeUpload(Path file, String ref, TransferStatus status, List<TransferStatus> checksums) throws BackgroundException {
        try {
            return new FilesApi(new BrickApiClient(this.session)).postFilesPath(new FilesPathBody().etagsEtag(checksums.stream().map(s -> s.getChecksum().hash).collect(Collectors.toList())).etagsPart(checksums.stream().map(TransferStatus::getPart).collect(Collectors.toList())).providedMtime(null != status.getTimestamp() ? new DateTime((Object)status.getTimestamp()) : null).ref(ref).action("end"), StringUtils.removeStart((String)file.getAbsolute(), (String)String.valueOf('/')));
        }
        catch (ApiException e) {
            throw new BrickExceptionMappingService().map("Upload {0} failed", e, file);
        }
    }

    private Future<TransferStatus> submit(ThreadPool pool, final Path file, final Local local, final BandwidthThrottle throttle, final StreamListener listener, final TransferStatus overall, final String url, final Integer partNumber, final long offset, final long length, final ConnectionCallback callback) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Submit part %d of %s to queue with offset %d and length %d", partNumber, file, offset, length));
        }
        BytecountStreamListener counter = new BytecountStreamListener(listener);
        return pool.execute((Callable)new SegmentRetryCallable(this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<TransferStatus>(){

            public TransferStatus call() throws BackgroundException {
                overall.validate();
                TransferStatus status = new TransferStatus().segment(true).withLength(length).withOffset(offset);
                status.setChecksum(BrickUploadFeature.this.writer.checksum(file, status).compute(local.getInputStream(), status));
                status.setUrl(url);
                status.setPart(partNumber);
                status.setHeader(overall.getHeader());
                BrickUploadFeature.super.upload(file, local, throttle, listener, status, (StreamCancelation)overall, (StreamProgress)status, callback);
                if (log.isInfoEnabled()) {
                    log.info(String.format("Received response for part number %d", partNumber));
                }
                return status;
            }
        }, (StreamCancelation)overall, counter));
    }
}

