/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.brick.BrickSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.http.DisabledServiceUnavailableRetryStrategy;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionRegistry;
import ch.cyberduck.core.threading.BackgroundActionState;
import ch.cyberduck.core.threading.BackgroundActionStateCancelCallback;
import ch.cyberduck.core.threading.CancelCallback;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrickUnauthorizedRetryStrategy
extends DisabledServiceUnavailableRetryStrategy
implements HttpRequestInterceptor {
    private static final Logger log = LogManager.getLogger(BrickUnauthorizedRetryStrategy.class);
    private static final int MAX_RETRIES = 1;
    private final Semaphore semaphore = new Semaphore(1);
    private final HostPasswordStore store = PasswordStoreFactory.get();
    private final BrickSession session;
    private final LoginCallback prompt;
    private final CancelCallback cancel;
    private String apiKey = "";

    public BrickUnauthorizedRetryStrategy(BrickSession session, LoginCallback prompt, CancelCallback cancel) {
        this.session = session;
        this.prompt = prompt;
        this.cancel = cancel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        switch (response.getStatusLine().getStatusCode()) {
            case 401: {
                if (executionCount <= 1) {
                    boolean bl;
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Try to acquire semaphore for %s", new Object[]{this.session}));
                    }
                    if (!this.semaphore.tryAcquire()) {
                        log.warn(String.format("Skip pairing because semaphore cannot be aquired for %s", new Object[]{this.session}));
                        return false;
                    }
                    try {
                        log.warn(String.format("Run pairing flow for %s", new Object[]{this.session}));
                        Credentials credentials = this.session.pair(this.session.getHost(), (ConnectionCallback)this.prompt, this.prompt, new BackgroundActionRegistryCancelCallback(this.cancel), LocaleFactory.localizedString((String)"You've been logged out", (String)"Brick"), LocaleFactory.localizedString((String)"Please complete the login process in your browser.", (String)"Brick"));
                        this.store.save(this.session.getHost());
                        this.apiKey = credentials.getPassword();
                        bl = true;
                    }
                    catch (BackgroundException e) {
                        try {
                            log.warn(String.format("Failure %s trying to refresh pairing after error response %s", new Object[]{e, response}));
                        }
                        catch (Throwable throwable) {
                            if (log.isDebugEnabled()) {
                                log.debug(String.format("Release semaphore for %s", new Object[]{this.session}));
                            }
                            this.semaphore.release();
                            throw throwable;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Release semaphore for %s", new Object[]{this.session}));
                        }
                        this.semaphore.release();
                        break;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Release semaphore for %s", new Object[]{this.session}));
                    }
                    this.semaphore.release();
                    return bl;
                }
                if (!log.isWarnEnabled()) break;
                log.warn(String.format("Skip retry for response %s after %d executions", response, executionCount));
            }
        }
        return false;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (StringUtils.isNotBlank((CharSequence)this.apiKey)) {
            request.removeHeaders("X-FilesAPI-Key");
            request.addHeader("X-FilesAPI-Key", this.apiKey);
        }
    }

    private static final class BackgroundActionRegistryCancelCallback
    implements CancelCallback {
        private final CancelCallback delegate;

        public BackgroundActionRegistryCancelCallback(CancelCallback delegate) {
            this.delegate = delegate;
        }

        public void verify() throws ConnectionCanceledException {
            this.delegate.verify();
            for (BackgroundAction action : BackgroundActionRegistry.global()) {
                if (null == action) continue;
                new BackgroundActionStateCancelCallback((BackgroundActionState)action).verify();
            }
        }
    }
}

