/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.brick.BrickAttributesFinderFeature;
import ch.cyberduck.core.brick.BrickSession;
import ch.cyberduck.core.brick.BrickUploadFeature;
import ch.cyberduck.core.brick.BrickWriteFeature;
import ch.cyberduck.core.brick.io.swagger.client.model.FileEntity;
import ch.cyberduck.core.brick.io.swagger.client.model.FileUploadPartEntity;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.util.Collections;

public class BrickTouchFeature
implements Touch<Void> {
    private final BrickSession session;

    public BrickTouchFeature(BrickSession session) {
        this.session = session;
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        try {
            BrickUploadFeature upload = new BrickUploadFeature(this.session, (Write<FileEntity>)new BrickWriteFeature(this.session));
            FileUploadPartEntity uploadPartEntity = upload.startUpload(file);
            status.withLength(0L).withOffset(0L);
            status.setUrl(uploadPartEntity.getUploadUri());
            status.setSegment(true);
            status.setTimestamp(Long.valueOf(System.currentTimeMillis()));
            status.setPart(Integer.valueOf(1));
            new BrickWriteFeature(this.session).write(file, status, (ConnectionCallback)new DisabledConnectionCallback()).close();
            FileEntity entity = upload.completeUpload(file, uploadPartEntity.getRef(), status, Collections.singletonList(status));
            return file.withAttributes(new BrickAttributesFinderFeature(this.session).toAttributes(entity));
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot create {0}", (Throwable)e, file);
        }
    }

    public Touch<Void> withWriter(Write<Void> writer) {
        return this;
    }
}

