/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.brick.BrickSession;
import ch.cyberduck.core.brick.BrickTouchFeature;
import ch.cyberduck.core.brick.BrickUploadFeature;
import ch.cyberduck.core.brick.BrickWriteFeature;
import ch.cyberduck.core.brick.io.swagger.client.model.FileEntity;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.transfer.TransferStatus;

public class BrickThresholdUploadFeature
implements Upload<FileEntity> {
    private final BrickSession session;
    private Write<FileEntity> writer;

    public BrickThresholdUploadFeature(BrickSession session) {
        this.session = session;
        this.writer = new BrickWriteFeature(session);
    }

    public FileEntity upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        if (status.getLength() > 0L) {
            return new BrickUploadFeature(this.session, this.writer).upload(file, local, throttle, listener, status, callback);
        }
        new BrickTouchFeature(this.session).touch(file, status);
        return null;
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return this.writer.append(file, status);
    }

    public Upload<FileEntity> withWriter(Write<FileEntity> writer) {
        this.writer = writer;
        return this;
    }
}

