/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.brick.BrickApiClient;
import ch.cyberduck.core.brick.BrickExceptionMappingService;
import ch.cyberduck.core.brick.BrickSession;
import ch.cyberduck.core.brick.io.swagger.client.ApiException;
import ch.cyberduck.core.brick.io.swagger.client.api.BundlesApi;
import ch.cyberduck.core.brick.io.swagger.client.model.BundlesBody;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.features.PromptUrlProvider;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;

public class BrickShareFeature
implements PromptUrlProvider {
    private final BrickSession session;

    public BrickShareFeature(BrickSession session) {
        this.session = session;
    }

    public boolean isSupported(Path file, PromptUrlProvider.Type type) {
        return type == PromptUrlProvider.Type.download;
    }

    public DescriptiveUrl toDownloadUrl(Path file, Object options, PasswordCallback callback) throws BackgroundException {
        try {
            String password = null;
            try {
                password = callback.prompt(this.session.getHost(), LocaleFactory.localizedString((String)"Passphrase", (String)"Cryptomator"), MessageFormat.format(LocaleFactory.localizedString((String)"Create a passphrase required to access {0}", (String)"Credentials"), file.getName()), new LoginOptions().keychain(false).icon(this.session.getHost().getProtocol().disk())).getPassword();
            }
            catch (LoginCanceledException loginCanceledException) {
                // empty catch block
            }
            return new DescriptiveUrl(URI.create(new BundlesApi(new BrickApiClient(this.session)).postBundles(new BundlesBody().password(password).paths(Collections.singletonList(StringUtils.removeStart((String)file.getAbsolute(), (String)String.valueOf('/'))))).getUrl()), DescriptiveUrl.Type.signed);
        }
        catch (ApiException e) {
            throw new BrickExceptionMappingService().map(e);
        }
    }

    public DescriptiveUrl toUploadUrl(Path file, Object options, PasswordCallback callback) throws BackgroundException {
        return DescriptiveUrl.EMPTY;
    }
}

