/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.brick.BrickAttributesFinderFeature;
import ch.cyberduck.core.brick.BrickCopyFeature;
import ch.cyberduck.core.brick.BrickCredentialsConfigurator;
import ch.cyberduck.core.brick.BrickDeleteFeature;
import ch.cyberduck.core.brick.BrickDirectoryFeature;
import ch.cyberduck.core.brick.BrickFindFeature;
import ch.cyberduck.core.brick.BrickListService;
import ch.cyberduck.core.brick.BrickLockFeature;
import ch.cyberduck.core.brick.BrickMoveFeature;
import ch.cyberduck.core.brick.BrickMultipartWriteFeature;
import ch.cyberduck.core.brick.BrickPairingSchedulerFeature;
import ch.cyberduck.core.brick.BrickPreferencesRequestInterceptor;
import ch.cyberduck.core.brick.BrickReadFeature;
import ch.cyberduck.core.brick.BrickShareFeature;
import ch.cyberduck.core.brick.BrickThresholdUploadFeature;
import ch.cyberduck.core.brick.BrickTimestampFeature;
import ch.cyberduck.core.brick.BrickTouchFeature;
import ch.cyberduck.core.brick.BrickUnauthorizedRetryStrategy;
import ch.cyberduck.core.brick.BrickUrlProvider;
import ch.cyberduck.core.brick.BrickWriteFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Lock;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.local.BrowserLauncher;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.shared.DefaultHomeFinderService;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrickSession
extends HttpSession<CloseableHttpClient> {
    private static final Logger log = LogManager.getLogger(BrickSession.class);
    private BrickUnauthorizedRetryStrategy retryHandler;

    public BrickSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    protected CloseableHttpClient connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt, CancelCallback cancel) {
        HttpClientBuilder configuration = this.builder.build(proxy, (TranscriptListener)this, prompt);
        this.retryHandler = new BrickUnauthorizedRetryStrategy(this, prompt, cancel);
        configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)this.retryHandler);
        configuration.addInterceptorLast((HttpRequestInterceptor)this.retryHandler);
        configuration.addInterceptorLast((HttpRequestInterceptor)new BrickPreferencesRequestInterceptor());
        return configuration.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void login(Proxy proxy, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        Credentials credentials = this.host.getCredentials();
        if (credentials.isPasswordAuthentication()) {
            this.retryHandler.setApiKey(credentials.getPassword());
            try {
                Path home = new DefaultHomeFinderService((Session)this).find();
                if (!log.isDebugEnabled()) return;
                log.debug(String.format("Retrieved %s", home));
                return;
            }
            catch (LoginFailureException e) {
                throw new LoginCanceledException((Throwable)e);
            }
        } else {
            this.pair(this.host, (ConnectionCallback)new DisabledConnectionCallback(), prompt, cancel, LocaleFactory.localizedString((String)"Connect an account", (String)"Brick"), LocaleFactory.localizedString((String)"Please complete the login process in your browser.", (String)"Brick")).setSaved(true);
            this.retryHandler.setApiKey(credentials.getPassword());
        }
    }

    protected void logout() throws BackgroundException {
        try {
            ((CloseableHttpClient)this.client).close();
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public Credentials pair(Host bookmark, ConnectionCallback alert, LoginCallback prompt, CancelCallback cancel, String title, String message) throws BackgroundException {
        return this.pair(bookmark, alert, prompt, cancel, title, message, BrowserLauncherFactory.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credentials pair(Host bookmark, final ConnectionCallback alert, final LoginCallback prompt, CancelCallback cancel, String title, String message, final BrowserLauncher browser) throws BackgroundException {
        final String token = new BrickCredentialsConfigurator().configure(this.host).getToken();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Attempt pairing with token %s", token));
        }
        BrickPairingSchedulerFeature scheduler = new BrickPairingSchedulerFeature(this, token, bookmark, cancel);
        DisabledConnectionCallback lock = new DisabledConnectionCallback(){
            final CountDownLatch lock = new CountDownLatch(1);

            public void close(String input) {
                prompt.close(input);
                this.lock.countDown();
            }

            public void warn(Host bookmark, String title, String message, String defaultButton, String cancelButton, String preference) throws ConnectionCanceledException {
                alert.warn(bookmark, title, message, defaultButton, cancelButton, preference);
                try {
                    StringBuilder url = new StringBuilder(String.format("%s/login_from_desktop?pairing_key=%s&platform=%s&computer=%s", new HostUrlProvider().withUsername(false).withPath(false).get(BrickSession.this.host), token, URIEncoder.encode((String)new PreferencesUseragentProvider().get()), URIEncoder.encode((String)InetAddress.getLocalHost().getHostName())));
                    if (StringUtils.isNotBlank((CharSequence)bookmark.getCredentials().getUsername())) {
                        url.append(String.format("&username=%s", URIEncoder.encode((String)bookmark.getCredentials().getUsername())));
                    }
                    if (!browser.open(url.toString())) {
                        throw new ConnectionCanceledException();
                    }
                }
                catch (UnknownHostException e) {
                    throw new ConnectionCanceledException((Throwable)e);
                }
                prompt.await(this.lock, bookmark, title, message);
                if (StringUtils.isBlank((CharSequence)bookmark.getCredentials().getPassword())) {
                    throw new LoginCanceledException();
                }
            }
        };
        scheduler.repeat((PasswordCallback)lock);
        try {
            lock.warn(bookmark, title, message, LocaleFactory.localizedString((String)"Login", (String)"Login"), LocaleFactory.localizedString((String)"Cancel"), null);
        }
        finally {
            scheduler.shutdown();
        }
        cancel.verify();
        return bookmark.getCredentials();
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == Upload.class) {
            return (T)new BrickThresholdUploadFeature(this);
        }
        if (type == MultipartWrite.class) {
            return (T)new BrickMultipartWriteFeature(this);
        }
        if (type == Write.class) {
            return (T)((Object)new BrickWriteFeature(this));
        }
        if (type == Touch.class) {
            return (T)new BrickTouchFeature(this);
        }
        if (type == Timestamp.class) {
            return (T)((Object)new BrickTimestampFeature(this));
        }
        if (type == UrlProvider.class) {
            return (T)((Object)new BrickUrlProvider(this.host));
        }
        if (type == ListService.class) {
            return (T)new BrickListService(this);
        }
        if (type == Read.class) {
            return (T)new BrickReadFeature(this);
        }
        if (type == Move.class) {
            return (T)new BrickMoveFeature(this);
        }
        if (type == Copy.class) {
            return (T)new BrickCopyFeature(this);
        }
        if (type == Directory.class) {
            return (T)new BrickDirectoryFeature(this);
        }
        if (type == Delete.class) {
            return (T)new BrickDeleteFeature(this);
        }
        if (type == Find.class) {
            return (T)new BrickFindFeature(this);
        }
        if (type == AttributesFinder.class) {
            return (T)new BrickAttributesFinderFeature(this);
        }
        if (type == Lock.class) {
            return (T)new BrickLockFeature(this);
        }
        if (type == PromptUrlProvider.class) {
            return (T)new BrickShareFeature(this);
        }
        return (T)super._getFeature(type);
    }
}

