/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;

public class BrickPreferencesRequestInterceptor
implements HttpRequestInterceptor {
    private final Preferences preferences = PreferencesFactory.get();

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        String value = this.toValue(this.preferences);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            request.addHeader((Header)new BasicHeader("X-User-Agent", value));
        }
    }

    protected String toValue(Preferences preferences) {
        LinkedHashMap<String, String> configuration = new LinkedHashMap<String, String>();
        if (preferences.getProperty("fs.sync.mode") != null) {
            configuration.put("sync", preferences.getProperty("fs.sync.mode"));
        }
        if (preferences.getBoolean("fs.sync.indexer.enable")) {
            configuration.put("index-files", "");
        }
        if (preferences.getBoolean("fs.lock.enable")) {
            configuration.put("lock-files", "");
        }
        if (preferences.getBoolean("fs.buffer.enable")) {
            configuration.put("enable-cache", "");
        }
        return this.toString(configuration);
    }

    protected String toString(Map<String, String> configuration) {
        return String.join((CharSequence)", ", configuration.entrySet().stream().map(entry -> String.format("%s%s", entry.getKey(), StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue())) ? String.format("=%s", entry.getValue()) : "")).collect(Collectors.toList()));
    }
}

