/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.CertificateIdentityCallback;
import ch.cyberduck.core.CertificateStoreFactory;
import ch.cyberduck.core.CertificateTrustCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledCertificateIdentityCallback;
import ch.cyberduck.core.DisabledCertificateTrustCallback;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.DisabledTranscriptListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Pairing;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.http.HttpConnectionPoolBuilder;
import ch.cyberduck.core.proxy.ProxyFactory;
import ch.cyberduck.core.proxy.ProxyHostUrlProvider;
import ch.cyberduck.core.ssl.DefaultTrustManagerHostnameCallback;
import ch.cyberduck.core.ssl.KeychainX509KeyManager;
import ch.cyberduck.core.ssl.KeychainX509TrustManager;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.TrustManagerHostnameCallback;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrickPairingFeature
implements Pairing {
    private static final Logger log = LogManager.getLogger(BrickPairingFeature.class);
    private final HostPasswordStore store = PasswordStoreFactory.get();

    public void delete(Host bookmark) throws BackgroundException {
        try {
            String token = this.store.findLoginPassword(bookmark);
            if (StringUtils.isNotBlank((CharSequence)token)) {
                log.warn(String.format("Delete pairing for %s", bookmark));
                KeychainX509TrustManager trust = new KeychainX509TrustManager((CertificateTrustCallback)new DisabledCertificateTrustCallback(), (TrustManagerHostnameCallback)new DefaultTrustManagerHostnameCallback(bookmark), CertificateStoreFactory.get());
                KeychainX509KeyManager key = new KeychainX509KeyManager((CertificateIdentityCallback)new DisabledCertificateIdentityCallback(), bookmark, CertificateStoreFactory.get());
                HttpConnectionPoolBuilder builder = new HttpConnectionPoolBuilder(bookmark, new ThreadLocalHostnameDelegatingTrustManager((X509TrustManager)trust, bookmark.getHostname()), (X509KeyManager)key, ProxyFactory.get());
                HttpClientBuilder configuration = builder.build(ProxyFactory.get().find(new ProxyHostUrlProvider().get(bookmark)), (TranscriptListener)new DisabledTranscriptListener(), (LoginCallback)new DisabledLoginCallback());
                configuration.setDefaultAuthSchemeRegistry((Lookup)RegistryBuilder.create().build());
                CloseableHttpClient client = configuration.build();
                HttpDelete resource = new HttpDelete(String.format("%s/api/rest/v1/api_key", new HostUrlProvider().withUsername(false).withPath(false).get(bookmark)));
                resource.setHeader("X-FilesAPI-Key", token);
                resource.setHeader("Accept", "application/json");
                resource.setHeader("Content-Type", "application/json");
                if (log.isInfoEnabled()) {
                    log.info(String.format("Delete paring key %s", token));
                }
                client.execute((HttpUriRequest)resource, (ResponseHandler)new ResponseHandler<Void>(){

                    public Void handleResponse(HttpResponse response) {
                        return null;
                    }
                });
                client.close();
            }
        }
        catch (HttpResponseException e) {
            throw new DefaultHttpResponseExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        finally {
            this.store.delete(bookmark);
        }
    }
}

