/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.brick.BrickApiClient;
import ch.cyberduck.core.brick.BrickAttributesFinderFeature;
import ch.cyberduck.core.brick.BrickExceptionMappingService;
import ch.cyberduck.core.brick.BrickSession;
import ch.cyberduck.core.brick.BrickTouchFeature;
import ch.cyberduck.core.brick.BrickWriteFeature;
import ch.cyberduck.core.brick.io.swagger.client.ApiException;
import ch.cyberduck.core.brick.io.swagger.client.api.FileActionsApi;
import ch.cyberduck.core.brick.io.swagger.client.api.FilesApi;
import ch.cyberduck.core.brick.io.swagger.client.model.BeginUploadPathBody;
import ch.cyberduck.core.brick.io.swagger.client.model.FileEntity;
import ch.cyberduck.core.brick.io.swagger.client.model.FileUploadPartEntity;
import ch.cyberduck.core.brick.io.swagger.client.model.FilesPathBody;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.DefaultStreamCloser;
import ch.cyberduck.core.io.MemorySegementingOutputStream;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;

public class BrickMultipartWriteFeature
implements MultipartWrite<FileEntity> {
    private static final Logger log = LogManager.getLogger(BrickMultipartWriteFeature.class);
    private final BrickSession session;
    private final Integer partsize;

    public BrickMultipartWriteFeature(BrickSession session) {
        this(session, new HostPreferences(session.getHost()).getInteger("brick.upload.multipart.size"));
    }

    public BrickMultipartWriteFeature(BrickSession session, Integer partsize) {
        this.session = session;
        this.partsize = partsize;
    }

    public HttpResponseOutputStream<FileEntity> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        final MultipartOutputStream proxy = new MultipartOutputStream(file, status);
        return new HttpResponseOutputStream<FileEntity>((OutputStream)new MemorySegementingOutputStream((OutputStream)proxy, this.partsize), (AttributesAdapter)new BrickAttributesFinderFeature(this.session), status){

            public FileEntity getStatus() {
                return proxy.getResponse();
            }
        };
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }

    private final class MultipartOutputStream
    extends OutputStream {
        private final BrickWriteFeature writer;
        private final Path file;
        private final TransferStatus overall;
        private final AtomicBoolean close;
        private final AtomicReference<FileEntity> response;
        private final AtomicReference<IOException> canceled;
        private final List<TransferStatus> checksums;
        private String ref;
        private int partNumber;

        public MultipartOutputStream(Path file, TransferStatus status) {
            this.writer = new BrickWriteFeature(BrickMultipartWriteFeature.this.session);
            this.close = new AtomicBoolean();
            this.response = new AtomicReference();
            this.canceled = new AtomicReference();
            this.checksums = new ArrayList<TransferStatus>();
            this.ref = null;
            this.file = file;
            this.overall = status;
        }

        @Override
        public void write(int value) throws IOException {
            throw new IOException(new UnsupportedOperationException());
        }

        @Override
        public void write(final byte[] b, final int off, final int len) throws IOException {
            try {
                if (null != this.canceled.get()) {
                    throw this.canceled.get();
                }
                ++this.partNumber;
                this.checksums.add((TransferStatus)new DefaultRetryCallable(BrickMultipartWriteFeature.this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<TransferStatus>(){

                    public TransferStatus call() throws BackgroundException {
                        List<FileUploadPartEntity> uploadPartEntities;
                        try {
                            uploadPartEntities = new FileActionsApi(new BrickApiClient(BrickMultipartWriteFeature.this.session)).beginUpload(StringUtils.removeStart((String)MultipartOutputStream.this.file.getAbsolute(), (String)String.valueOf('/')), new BeginUploadPathBody().ref(MultipartOutputStream.this.ref).part(MultipartOutputStream.this.partNumber));
                        }
                        catch (ApiException e) {
                            throw new BrickExceptionMappingService().map("Upload {0} failed", e, MultipartOutputStream.this.file);
                        }
                        Iterator<FileUploadPartEntity> iterator = uploadPartEntities.iterator();
                        if (iterator.hasNext()) {
                            FileUploadPartEntity uploadPartEntity = iterator.next();
                            TransferStatus status = new TransferStatus().withLength((long)len);
                            status.setChecksum(MultipartOutputStream.this.writer.checksum(MultipartOutputStream.this.file, status).compute((InputStream)new ByteArrayInputStream(b, off, len), status));
                            status.setUrl(uploadPartEntity.getUploadUri());
                            status.setSegment(true);
                            HttpResponseOutputStream<FileEntity> proxy = MultipartOutputStream.this.writer.write(MultipartOutputStream.this.file, status, (ConnectionCallback)new DisabledConnectionCallback());
                            byte[] content = Arrays.copyOfRange(b, off, len);
                            try {
                                IOUtils.write((byte[])content, proxy);
                            }
                            catch (IOException e) {
                                MultipartOutputStream.this.canceled.set(e);
                                throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, MultipartOutputStream.this.file);
                            }
                            finally {
                                new DefaultStreamCloser().close(proxy);
                            }
                            MultipartOutputStream.this.ref = uploadPartEntity.getRef();
                            return status;
                        }
                        throw new InteroperabilityException();
                    }
                }, (StreamCancelation)this.overall).call());
            }
            catch (BackgroundException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        @Override
        public void close() throws IOException {
            block13: {
                try {
                    if (this.close.get()) {
                        log.warn(String.format("Skip double close of stream %s", this));
                        return;
                    }
                    if (null != this.canceled.get()) {
                        log.warn(String.format("Skip closing with previous failure %s", this.canceled.get()));
                        return;
                    }
                    if (null == this.ref) {
                        new BrickTouchFeature(BrickMultipartWriteFeature.this.session).touch(this.file, new TransferStatus());
                        break block13;
                    }
                    try {
                        this.response.set(new FilesApi(new BrickApiClient(BrickMultipartWriteFeature.this.session)).postFilesPath(new FilesPathBody().providedMtime(null != this.overall.getTimestamp() ? new DateTime((Object)this.overall.getTimestamp()) : null).etagsEtag(this.checksums.stream().map(s -> s.getChecksum().hash).collect(Collectors.toList())).etagsPart(this.checksums.stream().map(TransferStatus::getPart).collect(Collectors.toList())).ref(this.ref).action("end"), StringUtils.removeStart((String)this.file.getAbsolute(), (String)String.valueOf('/'))));
                    }
                    catch (ApiException e) {
                        throw new IOException(e.getMessage(), new BrickExceptionMappingService().map("Upload {0} failed", e, this.file));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Completed multipart upload for %s", this.file));
                    }
                }
                catch (BackgroundException e) {
                    throw new IOException(e);
                }
                finally {
                    this.close.set(true);
                }
            }
        }

        public FileEntity getResponse() {
            return this.response.get();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MultipartOutputStream{");
            sb.append("file=").append(this.file);
            sb.append('}');
            return sb.toString();
        }
    }
}

