/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.brick.BrickApiClient;
import ch.cyberduck.core.brick.BrickDeleteFeature;
import ch.cyberduck.core.brick.BrickExceptionMappingService;
import ch.cyberduck.core.brick.BrickFileMigrationFeature;
import ch.cyberduck.core.brick.BrickSession;
import ch.cyberduck.core.brick.io.swagger.client.ApiException;
import ch.cyberduck.core.brick.io.swagger.client.api.FileActionsApi;
import ch.cyberduck.core.brick.io.swagger.client.model.FileActionEntity;
import ch.cyberduck.core.brick.io.swagger.client.model.MovePathBody;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrickMoveFeature
extends BrickFileMigrationFeature
implements Move {
    private static final Logger log = LogManager.getLogger(BrickMoveFeature.class);
    private final BrickSession session;
    private final Preferences preferences = PreferencesFactory.get();

    public BrickMoveFeature(BrickSession session) {
        this.session = session;
    }

    public Path move(Path file, Path target, TransferStatus status, Delete.Callback delete, ConnectionCallback callback) throws BackgroundException {
        try {
            FileActionEntity entity;
            BrickApiClient client = new BrickApiClient(this.session);
            if (status.isExists()) {
                if (log.isWarnEnabled()) {
                    log.warn(String.format("Delete file %s to be replaced with %s", target, file));
                }
                new BrickDeleteFeature(this.session).delete(Collections.singletonList(target), (PasswordCallback)callback, delete);
            }
            if ((entity = new FileActionsApi(client).move(new MovePathBody().destination(StringUtils.removeStart((String)target.getAbsolute(), (String)String.valueOf('/'))), StringUtils.removeStart((String)file.getAbsolute(), (String)String.valueOf('/')))).getFileMigrationId() != null) {
                this.poll(client, entity);
            }
            return target.withAttributes(file.attributes());
        }
        catch (ApiException e) {
            throw new BrickExceptionMappingService().map("Cannot rename {0}", e, file);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }
}

