/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.brick.BrickApiClient;
import ch.cyberduck.core.brick.BrickExceptionMappingService;
import ch.cyberduck.core.brick.BrickSession;
import ch.cyberduck.core.brick.io.swagger.client.ApiException;
import ch.cyberduck.core.brick.io.swagger.client.api.LocksApi;
import ch.cyberduck.core.brick.io.swagger.client.model.LocksPathBody;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Lock;
import org.apache.commons.lang3.StringUtils;

public class BrickLockFeature
implements Lock<String> {
    private final BrickSession session;

    public BrickLockFeature(BrickSession session) {
        this.session = session;
    }

    public String lock(Path file) throws BackgroundException {
        try {
            return new LocksApi(new BrickApiClient(this.session)).postLocksPath(StringUtils.removeStart((String)file.getAbsolute(), (String)String.valueOf('/')), new LocksPathBody().exclusive(true).allowAccessByAnyUser(true)).getToken();
        }
        catch (ApiException e) {
            throw new BrickExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
    }

    public void unlock(Path file, String token) throws BackgroundException {
        try {
            new LocksApi(new BrickApiClient(this.session)).deleteLocksPath(StringUtils.removeStart((String)file.getAbsolute(), (String)String.valueOf('/')), token);
        }
        catch (ApiException e) {
            throw new BrickExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
    }
}

