/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.brick.BrickApiClient;
import ch.cyberduck.core.brick.BrickAttributesFinderFeature;
import ch.cyberduck.core.brick.BrickExceptionMappingService;
import ch.cyberduck.core.brick.BrickSession;
import ch.cyberduck.core.brick.io.swagger.client.ApiException;
import ch.cyberduck.core.brick.io.swagger.client.api.FoldersApi;
import ch.cyberduck.core.brick.io.swagger.client.model.FileEntity;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.preferences.HostPreferences;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class BrickListService
implements ListService {
    private final BrickSession session;
    private final BrickAttributesFinderFeature attributes;

    public BrickListService(BrickSession session) {
        this.session = session;
        this.attributes = new BrickAttributesFinderFeature(session);
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        return this.list(directory, listener, new HostPreferences(this.session.getHost()).getInteger("brick.listing.chunksize"));
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener, int chunksize) throws BackgroundException {
        try {
            AttributedList children = new AttributedList();
            String cursor = null;
            BrickApiClient client = new BrickApiClient(this.session);
            do {
                List<FileEntity> response = new FoldersApi(client).foldersListForPath(StringUtils.removeStart((String)directory.getAbsolute(), (String)String.valueOf('/')), cursor, chunksize, null, null, null, null, null, null);
                for (FileEntity entity : response) {
                    children.add((Referenceable)new Path(directory, entity.getDisplayName(), EnumSet.of("directory".equals(entity.getType()) ? AbstractPath.Type.directory : AbstractPath.Type.file), this.attributes.toAttributes(entity)));
                }
                if (client.getResponseHeaders().containsKey("X-Files-Cursor")) {
                    Optional header = client.getResponseHeaders().get("X-Files-Cursor").stream().findFirst();
                    cursor = header.orElse(null);
                } else {
                    cursor = null;
                }
                listener.chunk(directory, children);
            } while (cursor != null);
            return children;
        }
        catch (ApiException e) {
            throw new BrickExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
    }
}

