/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.brick.BrickApiClient;
import ch.cyberduck.core.brick.BrickExceptionMappingService;
import ch.cyberduck.core.brick.io.swagger.client.ApiException;
import ch.cyberduck.core.brick.io.swagger.client.api.FileMigrationsApi;
import ch.cyberduck.core.brick.io.swagger.client.model.FileActionEntity;
import ch.cyberduck.core.brick.io.swagger.client.model.FileMigrationEntity;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.LoggingUncaughtExceptionHandler;
import ch.cyberduck.core.threading.ScheduledThreadPool;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrickFileMigrationFeature {
    private static final Logger log = LogManager.getLogger(BrickFileMigrationFeature.class);
    private final Preferences preferences = PreferencesFactory.get();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void poll(BrickApiClient client, FileActionEntity entity) throws BackgroundException {
        final CountDownLatch signal = new CountDownLatch(1);
        final AtomicReference failure = new AtomicReference();
        ScheduledThreadPool scheduler = new ScheduledThreadPool((Thread.UncaughtExceptionHandler)new LoggingUncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                super.uncaughtException(t, e);
                failure.set(new BackgroundException(e));
                signal.countDown();
            }
        });
        long timeout = this.preferences.getLong("brick.migration.interrupt.ms");
        long start = System.currentTimeMillis();
        try {
            ScheduledFuture f = scheduler.repeat(() -> {
                try {
                    if (System.currentTimeMillis() - start > timeout) {
                        failure.set(new ConnectionCanceledException(String.format("Interrupt polling for migration key after %d", timeout)));
                        signal.countDown();
                        return;
                    }
                    FileMigrationEntity.StatusEnum migration = new FileMigrationsApi(client).getFileMigrationsId(entity.getFileMigrationId()).getStatus();
                    switch (migration) {
                        case COMPLETED: {
                            signal.countDown();
                            return;
                        }
                    }
                    log.warn(String.format("Wait for copy to complete with current status %s", new Object[]{migration}));
                }
                catch (ApiException e) {
                    log.warn(String.format("Failure processing scheduled task. %s", e.getMessage()), (Throwable)e);
                    failure.set(new BrickExceptionMappingService().map(e));
                    signal.countDown();
                }
            }, Long.valueOf(this.preferences.getLong("brick.migration.interval.ms")), TimeUnit.MILLISECONDS);
            while (!Uninterruptibles.awaitUninterruptibly((CountDownLatch)signal, (Duration)Duration.ofSeconds(1L))) {
                try {
                    if (!f.isDone()) continue;
                    Uninterruptibles.getUninterruptibly((Future)f);
                }
                catch (ExecutionException e) {
                    Throwables.throwIfInstanceOf((Throwable)Throwables.getRootCause((Throwable)e), BackgroundException.class);
                    throw new DefaultExceptionMappingService().map(Throwables.getRootCause((Throwable)e));
                }
            }
            if (null != failure.get()) {
                throw (BackgroundException)((Object)failure.get());
            }
        }
        finally {
            scheduler.shutdown();
        }
    }
}

