/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.AbstractExceptionMappingService;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DefaultSocketExceptionMappingService;
import ch.cyberduck.core.brick.io.swagger.client.ApiException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.LockedException;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.client.HttpResponseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrickExceptionMappingService
extends AbstractExceptionMappingService<ApiException> {
    private static final Logger log = LogManager.getLogger(BrickExceptionMappingService.class);

    public BackgroundException map(ApiException failure) {
        switch (failure.getCode()) {
            case 422: {
                return new LockedException("", (Throwable)failure);
            }
        }
        for (Throwable cause : ExceptionUtils.getThrowableList((Throwable)failure)) {
            if (cause instanceof SocketException) {
                return new DefaultSocketExceptionMappingService().map((SocketException)cause);
            }
            if (cause instanceof HttpResponseException) {
                return new DefaultHttpResponseExceptionMappingService().map((HttpResponseException)cause);
            }
            if (cause instanceof IOException) {
                return new DefaultIOExceptionMappingService().map((IOException)cause);
            }
            if (!(cause instanceof IllegalStateException)) continue;
            return new ConnectionCanceledException(cause);
        }
        StringBuilder buffer = new StringBuilder();
        this.parse(buffer, failure.getResponseBody());
        return new DefaultHttpResponseExceptionMappingService().map((Throwable)failure, buffer, failure.getCode());
    }

    private void parse(StringBuilder buffer, String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return;
        }
        try {
            JsonElement element = JsonParser.parseReader((Reader)new StringReader(message));
            if (element.isJsonObject()) {
                JsonObject json = element.getAsJsonObject();
                JsonPrimitive error = json.getAsJsonPrimitive("error");
                if (null == error) {
                    this.append(buffer, message);
                } else {
                    this.append(buffer, error.getAsString());
                }
            }
            if (element.isJsonPrimitive()) {
                this.append(buffer, element.getAsString());
            }
        }
        catch (JsonParseException jsonParseException) {
            // empty catch block
        }
    }
}

