/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.brick.BrickApiClient;
import ch.cyberduck.core.brick.BrickAttributesFinderFeature;
import ch.cyberduck.core.brick.BrickExceptionMappingService;
import ch.cyberduck.core.brick.BrickSession;
import ch.cyberduck.core.brick.io.swagger.client.ApiException;
import ch.cyberduck.core.brick.io.swagger.client.api.FoldersApi;
import ch.cyberduck.core.brick.io.swagger.client.model.FileEntity;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.transfer.TransferStatus;
import org.apache.commons.lang3.StringUtils;

public class BrickDirectoryFeature
implements Directory<FileEntity> {
    private final BrickSession session;

    public BrickDirectoryFeature(BrickSession session) {
        this.session = session;
    }

    public Path mkdir(Path folder, TransferStatus status) throws BackgroundException {
        try {
            return folder.withAttributes(new BrickAttributesFinderFeature(this.session).toAttributes(new FoldersApi(new BrickApiClient(this.session)).postFoldersPath(StringUtils.removeStart((String)folder.getAbsolute(), (String)String.valueOf('/')))));
        }
        catch (ApiException e) {
            throw new BrickExceptionMappingService().map("Cannot create folder {0}", e, folder);
        }
    }

    public Directory<FileEntity> withWriter(Write<FileEntity> writer) {
        return this;
    }
}

