/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.brick.BrickApiClient;
import ch.cyberduck.core.brick.BrickExceptionMappingService;
import ch.cyberduck.core.brick.BrickSession;
import ch.cyberduck.core.brick.io.swagger.client.ApiException;
import ch.cyberduck.core.brick.io.swagger.client.api.FilesApi;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BrickDeleteFeature
implements Delete {
    private final BrickSession session;

    public BrickDeleteFeature(BrickSession session) {
        this.session = session;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (Path f : files.keySet()) {
            try {
                new FilesApi(new BrickApiClient(this.session)).deleteFilesPath(StringUtils.removeStart((String)f.getAbsolute(), (String)String.valueOf('/')), f.isDirectory());
            }
            catch (ApiException e) {
                throw new BrickExceptionMappingService().map("Cannot delete {0}", e, f);
            }
        }
    }

    public boolean isRecursive() {
        return true;
    }
}

