/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.brick.BrickApiClient;
import ch.cyberduck.core.brick.BrickDeleteFeature;
import ch.cyberduck.core.brick.BrickExceptionMappingService;
import ch.cyberduck.core.brick.BrickFileMigrationFeature;
import ch.cyberduck.core.brick.BrickSession;
import ch.cyberduck.core.brick.io.swagger.client.ApiException;
import ch.cyberduck.core.brick.io.swagger.client.api.FileActionsApi;
import ch.cyberduck.core.brick.io.swagger.client.model.CopyPathBody;
import ch.cyberduck.core.brick.io.swagger.client.model.FileActionEntity;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrickCopyFeature
extends BrickFileMigrationFeature
implements Copy {
    private static final Logger log = LogManager.getLogger(BrickCopyFeature.class);
    private final BrickSession session;

    public BrickCopyFeature(BrickSession session) {
        this.session = session;
    }

    public Path copy(Path file, Path target, TransferStatus status, ConnectionCallback callback, StreamListener listener) throws BackgroundException {
        try {
            BrickApiClient client = new BrickApiClient(this.session);
            if (status.isExists()) {
                if (log.isWarnEnabled()) {
                    log.warn(String.format("Delete file %s to be replaced with %s", target, file));
                }
                new BrickDeleteFeature(this.session).delete(Collections.singletonList(target), (PasswordCallback)callback, (Delete.Callback)new Delete.DisabledCallback());
            }
            FileActionEntity entity = new FileActionsApi(client).copy(new CopyPathBody().destination(StringUtils.removeStart((String)target.getAbsolute(), (String)String.valueOf('/'))), StringUtils.removeStart((String)file.getAbsolute(), (String)String.valueOf('/')));
            listener.sent(status.getLength());
            if (entity.getFileMigrationId() != null) {
                this.poll(client, entity);
            }
            return target.withAttributes(file.attributes());
        }
        catch (ApiException e) {
            throw new BrickExceptionMappingService().map("Cannot copy {0}", e, file);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }
}

