/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.brick.BrickApiClient;
import ch.cyberduck.core.brick.BrickExceptionMappingService;
import ch.cyberduck.core.brick.BrickSession;
import ch.cyberduck.core.brick.io.swagger.client.ApiException;
import ch.cyberduck.core.brick.io.swagger.client.api.FilesApi;
import ch.cyberduck.core.brick.io.swagger.client.model.FileEntity;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.io.Checksum;
import org.apache.commons.lang3.StringUtils;

public class BrickAttributesFinderFeature
implements AttributesFinder,
AttributesAdapter<FileEntity> {
    private final BrickSession session;

    public BrickAttributesFinderFeature(BrickSession session) {
        this.session = session;
    }

    public PathAttributes find(Path file, ListProgressListener listener) throws BackgroundException {
        try {
            FileEntity entity = new FilesApi(new BrickApiClient(this.session)).download(StringUtils.removeStart((String)file.getAbsolute(), (String)String.valueOf('/')), "stat", null, false, false);
            switch (entity.getType()) {
                case "file": {
                    if (!file.isDirectory()) break;
                    throw new NotfoundException(file.getAbsolute());
                }
                case "directory": {
                    if (!file.isFile()) break;
                    throw new NotfoundException(file.getAbsolute());
                }
            }
            return this.toAttributes(entity);
        }
        catch (ApiException e) {
            throw new BrickExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    public PathAttributes toAttributes(FileEntity entity) {
        PathAttributes attr = new PathAttributes();
        attr.setChecksum(Checksum.parse((String)entity.getMd5()));
        attr.setRegion(entity.getRegion());
        if (entity.getSize() != null) {
            attr.setSize(entity.getSize().longValue());
        }
        if (entity.getProvidedMtime() != null) {
            attr.setModificationDate(entity.getProvidedMtime().getMillis());
        } else if (entity.getMtime() != null) {
            attr.setModificationDate(entity.getMtime().getMillis());
        }
        return attr;
    }
}

