/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav.microsoft;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.date.InvalidDateException;
import ch.cyberduck.core.date.RFC1123DateFormatter;
import ch.cyberduck.core.dav.DAVAttributesFinderFeature;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVPathEncoder;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.dav.microsoft.MicrosoftIISDAVTimestampFeature;
import com.github.sardine.DavResource;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MicrosoftIISDAVAttributesFinderFeature
extends DAVAttributesFinderFeature {
    private static final Logger log = LogManager.getLogger(MicrosoftIISDAVAttributesFinderFeature.class);
    private final DAVSession session;
    private final RFC1123DateFormatter rfc1123 = new RFC1123DateFormatter();

    public MicrosoftIISDAVAttributesFinderFeature(DAVSession session) {
        super(session);
        this.session = session;
    }

    @Override
    protected List<DavResource> list(Path file) throws IOException {
        return ((DAVClient)((Object)this.session.getClient())).list(new DAVPathEncoder().encode(file), 0, true);
    }

    @Override
    public PathAttributes toAttributes(DavResource resource) {
        PathAttributes attributes = super.toAttributes(resource);
        Map properties = resource.getCustomPropsNS();
        if (null != properties && properties.containsKey(MicrosoftIISDAVTimestampFeature.LAST_MODIFIED_WIN32_CUSTOM_NAMESPACE)) {
            String value = (String)properties.get(MicrosoftIISDAVTimestampFeature.LAST_MODIFIED_WIN32_CUSTOM_NAMESPACE);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                try {
                    attributes.setModificationDate(this.rfc1123.parse(value).getTime());
                }
                catch (InvalidDateException e) {
                    log.warn(String.format("Failure parsing property %s with value %s", MicrosoftIISDAVTimestampFeature.LAST_MODIFIED_WIN32_CUSTOM_NAMESPACE, value));
                    if (resource.getModified() != null) {
                        attributes.setModificationDate(resource.getModified().getTime());
                    }
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Missing value for property %s", MicrosoftIISDAVTimestampFeature.LAST_MODIFIED_WIN32_CUSTOM_NAMESPACE));
                }
                if (resource.getModified() != null) {
                    attributes.setModificationDate(resource.getModified().getTime());
                }
            }
        }
        return attributes;
    }
}

