/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.VoidAttributesAdapter;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVExceptionMappingService;
import ch.cyberduck.core.dav.DAVPathEncoder;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.Lock;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.transfer.TransferStatus;
import com.github.sardine.impl.SardineException;
import com.github.sardine.impl.handler.ETagResponseHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DAVWriteFeature
extends AbstractHttpWriteFeature<Void>
implements Write<Void> {
    private static final Logger log = LogManager.getLogger(DAVWriteFeature.class);
    private final DAVSession session;
    private final boolean expect;

    public DAVWriteFeature(DAVSession session) {
        this(session, new HostPreferences(session.getHost()).getBoolean("webdav.expect-continue"));
    }

    public DAVWriteFeature(DAVSession session, boolean expect) {
        super((AttributesAdapter)new VoidAttributesAdapter());
        this.session = session;
        this.expect = expect;
    }

    public HttpResponseOutputStream<Void> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        List<Header> headers = this.getHeaders(file, status);
        return this.write(file, headers, status);
    }

    protected List<Header> getHeaders(Path file, TransferStatus status) throws UnsupportedException {
        ArrayList<Header> headers = new ArrayList<Header>();
        if (status.isAppend()) {
            if (status.getLength() == -1L) {
                throw new UnsupportedException("Content-Range with unknown file size is not supported");
            }
            HttpRange range = HttpRange.withStatus((TransferStatus)status);
            String header = String.format("bytes %d-%d/%d", range.getStart(), range.getEnd(), status.getOffset() + status.getLength());
            if (log.isDebugEnabled()) {
                log.debug(String.format("Add range header %s for file %s", header, file));
            }
            headers.add((Header)new BasicHeader("Content-Range", header));
        }
        if (this.expect && status.getLength() > 0L) {
            headers.add((Header)new BasicHeader("Expect", "100-continue"));
        }
        if (this.session.getFeature(Lock.class) != null && status.getLockId() != null) {
            headers.add((Header)new BasicHeader("If", String.format("(<%s>)", status.getLockId())));
        }
        return headers;
    }

    private HttpResponseOutputStream<Void> write(final Path file, final List<Header> headers, final TransferStatus status) throws BackgroundException {
        DelayedHttpEntityCallable<Void> command = new DelayedHttpEntityCallable<Void>(){

            public Void call(AbstractHttpEntity entity) throws BackgroundException {
                try {
                    try {
                        ((DAVClient)((Object)DAVWriteFeature.this.session.getClient())).put(new DAVPathEncoder().encode(file), (HttpEntity)entity, headers, (ResponseHandler)new ETagResponseHandler());
                        return null;
                    }
                    catch (SardineException e) {
                        try {
                            if (null != status.getLockId()) {
                                switch (e.getStatusCode()) {
                                    case 412: {
                                        log.warn(String.format("Retry failure %s with lock id %s removed", new Object[]{e, status.getLockId()}));
                                        headers.removeIf(header -> "If".equals(header.getName()));
                                        ((DAVClient)((Object)DAVWriteFeature.this.session.getClient())).put(new DAVPathEncoder().encode(file), (HttpEntity)entity, headers, (ResponseHandler)new ETagResponseHandler());
                                        return null;
                                    }
                                }
                            }
                            throw e;
                        }
                        catch (SardineException e2) {
                            throw new DAVExceptionMappingService().map("Upload {0} failed", e2, file);
                        }
                    }
                }
                catch (IOException e) {
                    throw new HttpExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
                }
            }

            public long getContentLength() {
                return status.getLength();
            }
        };
        return this.write(file, status, (DelayedHttpEntityCallable)command);
    }

    public boolean random() {
        return true;
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        if (status.getLength() == -1L) {
            return new Write.Append(false).withStatus(status);
        }
        return super.append(file, status);
    }
}

